/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.content.kinetics.steamEngine.SteamEngineValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.network.chat.Component;

public class RotationDirectionScrollBehaviour
extends ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> {
    public RotationDirectionScrollBehaviour(SmartBlockEntity be, Component title, ValueBoxTransform slot) {
        super(RotationDirectionIcon.class, RotationDirectionIcon::from, title, be, slot);
    }

    public static RotationDirectionScrollBehaviour windmill(WindmillBearingBlockEntity be) {
        return new RotationDirectionScrollBehaviour(be, (Component)CreateLang.translateDirect("contraptions.windmill.rotation_direction", new Object[0]), RotationDirectionScrollBehaviour.getMovementModeSlot());
    }

    public static BlockEntityBehaviour<SmartBlockEntity> engine(SteamEngineBlockEntity be) {
        return new RotationDirectionScrollBehaviour(be, (Component)CreateLang.translateDirect("contraptions.windmill.rotation_direction", new Object[0]), (ValueBoxTransform)new SteamEngineValueBox()).onlyActiveWhen(() -> {
            PoweredShaftBlockEntity shaft = be.getShaft();
            return shaft == null || !shaft.hasSource();
        });
    }

    private static enum RotationDirectionIcon implements INamedIconOptions
    {
        CLOCKWISE(AllIcons.I_REFRESH),
        COUNTER_CLOCKWISE(AllIcons.I_ROTATE_CCW);

        private final String translationKey;
        private final AllIcons icon;

        private RotationDirectionIcon(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create.generic." + Lang.asId(this.name());
        }

        public static RotationDirectionIcon from(WindmillBearingBlockEntity.RotationDirection direction) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case WindmillBearingBlockEntity.RotationDirection.CLOCKWISE -> CLOCKWISE;
                case WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE -> COUNTER_CLOCKWISE;
            };
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

