/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ScrollValueRenderer {
    public static void tick(Minecraft mc) {
        boolean highlight;
        HitResult target = mc.hitResult;
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.level;
        if (world == null) {
            return;
        }
        BlockPos pos = result.getBlockPos();
        Direction face = result.getDirection();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        ScrollValueBehaviour<?, ?> behaviour = sbe.getBehaviour(ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            Outliner.getInstance().remove(behaviour);
            return;
        }
        ItemStack mainhandItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean clipboard = behaviour.bypassesInput(mainhandItem);
        if (behaviour.needsWrench && !mainhandItem.is((Item)AllItems.WRENCH) && !clipboard) {
            return;
        }
        boolean bl = highlight = behaviour.testHit(target.getLocation()) && !clipboard;
        if (AllKeys.hasControlDown()) {
            List<SmartBlockEntity> bulks = behaviour.getBulk();
            if (bulks != null) {
                for (SmartBlockEntity smartBlockEntity : bulks) {
                    ScrollValueBehaviour<?, ?> scrollValueBehaviour = smartBlockEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                    if (!(scrollValueBehaviour instanceof ScrollValueBehaviour)) continue;
                    ScrollValueBehaviour<?, ?> other = scrollValueBehaviour;
                    ScrollValueRenderer.addBox(smartBlockEntity.getBlockPos(), face, other, highlight);
                }
            } else {
                ScrollValueRenderer.addBox(pos, face, behaviour, highlight);
            }
        } else {
            ScrollValueRenderer.addBox(pos, face, behaviour, highlight);
        }
        if (!highlight) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(behaviour.label.copy());
        tip.add(CreateLang.translateDirect("gui.value_settings.hold_to_edit", new Object[0]));
        Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
    }

    protected static void addBox(BlockPos pos, Direction face, ScrollValueBehaviour<?, ?> behaviour, boolean highlight) {
        ValueBox box;
        AABB bb = new AABB(Vec3.ZERO, Vec3.ZERO).inflate(0.5).contract(0.0, 0.0, -0.5).move(0.0, 0.0, -0.125);
        Component label = behaviour.label;
        if (behaviour instanceof ScrollOptionBehaviour) {
            ScrollOptionBehaviour optionBehaviour = (ScrollOptionBehaviour)behaviour;
            box = new ValueBox.IconValueBox(label, optionBehaviour.getIconForSelected(), bb, pos);
        } else {
            box = new ValueBox.TextValueBox(label, bb, pos, (Component)Component.literal((String)behaviour.formatValue()));
        }
        box.passive(!highlight).wideOutline();
        Outliner.getInstance().showOutline(behaviour, box.transform(behaviour.slotPositioning)).highlightFace(face);
    }
}

