/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.KineticTooltipBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GeneratingKineticTooltipBehaviour<T extends KineticBlockEntity>
extends KineticTooltipBehaviour<T> {
    public GeneratingKineticTooltipBehaviour(T be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = ((KineticBlockEntity)this.blockEntity).calculateAddedStressCapacity();
        if (Mth.equal((float)stressBase, (float)0.0f)) {
            return added;
        }
        CreateLang.translate("gui.goggles.generator_stats", new Object[0]).forGoggles(tooltip);
        CreateLang.translate("tooltip.capacityProvided", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float speed = ((KineticBlockEntity)this.blockEntity).getTheoreticalSpeed();
        if (speed != ((KineticBlockEntity)this.blockEntity).getGeneratedSpeed() && speed != 0.0f) {
            stressBase *= ((KineticBlockEntity)this.blockEntity).getGeneratedSpeed() / speed;
        }
        float stressTotal = Math.abs(stressBase * speed);
        CreateLang.number(stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate("gui.goggles.at_current_speed", new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }
}

