/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.content.contraptions.IDisplayAssemblyExceptions;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.GeneratingKineticTooltipBehaviour;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MechanicalBearingTooltipBehaviour
extends GeneratingKineticTooltipBehaviour<MechanicalBearingBlockEntity>
implements IDisplayAssemblyExceptions {
    public MechanicalBearingTooltipBehaviour(MechanicalBearingBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (!((MechanicalBearingBlockEntity)this.blockEntity).isWindmill() && ((MechanicalBearingBlockEntity)this.blockEntity).getSpeed() == 0.0f) {
            return false;
        }
        if (((MechanicalBearingBlockEntity)this.blockEntity).isRunning()) {
            return false;
        }
        BlockState state = ((MechanicalBearingBlockEntity)this.blockEntity).getBlockState();
        if (!(state.getBlock() instanceof BearingBlock)) {
            return false;
        }
        BlockState attachedState = ((MechanicalBearingBlockEntity)this.blockEntity).getLevel().getBlockState(((MechanicalBearingBlockEntity)this.blockEntity).getBlockPos().relative((Direction)state.getValue((Property)BearingBlock.FACING)));
        if (attachedState.canBeReplaced()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.empty_bearing", new Object[0]);
        return true;
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return ((MechanicalBearingBlockEntity)this.blockEntity).getLastAssemblyException();
    }
}

