/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class DeployerRenderer
extends PictureInPictureRenderer<DeployerRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public DeployerRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(DeployerRenderState item, GuiRenderState state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 26 * windowScaleFactor;
        int height = 75 * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate((float)width / 2.0f, (float)height, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.scale(scale, scale, scale);
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        this.matrices.translate(-0.5f, -2.24f, -0.5f);
        this.matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        float time = AnimationTickHolder.getRenderTime();
        float cycle = (time - (float)(item.offset() * 8)) % 30.0f;
        float offset = cycle < 10.0f ? cycle / 10.0f : (cycle < 20.0f ? (20.0f - cycle) / 10.0f : 0.0f);
        this.matrices.pushPose();
        BlockState blockState = (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
        world.blockState(blockState);
        List parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        this.matrices.translate(0.5f, 0.5f, 0.5f);
        this.matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(DeployerRenderer.getCurrentAngle(time)));
        this.matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.popPose();
        blockState = (BlockState)((BlockState)AllBlocks.DEPLOYER.defaultBlockState().setValue((Property)DeployerBlock.FACING, (Comparable)Direction.DOWN)).setValue((Property)DeployerBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false));
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.pushPose();
        blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.DEPLOYER_POLE.get(), AllPartialModels.DEPLOYER_HAND_HOLDING.get());
        this.matrices.translate(0.0f, -offset, 0.0f);
        this.matrices.translate(0.5f, 0.5f, 0.5f);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        this.matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.popPose();
        this.matrices.translate(0.0f, -2.06f, 0.0f);
        blockState = AllBlocks.DEPOT.defaultBlockState();
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.bufferSource.endBatch();
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), item.pose(), item.x0(), item.y0(), item.x1(), item.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    public static float getCurrentAngle(float time) {
        return time * 4.0f % 360.0f;
    }

    protected void renderToTexture(DeployerRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Deployer";
    }

    public Class<DeployerRenderState> getRenderStateClass() {
        return DeployerRenderState.class;
    }
}

