/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.FanRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.joml.Quaternionfc;

public class FanRenderer
extends PictureInPictureRenderer<FanRenderState> {
    private static final RandomSource RANDOM = RandomSource.create();

    public FanRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(FanRenderState state, PoseStack matrices) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        matrices.translate(-0.92f, -0.75f, -0.5f);
        matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        matrices.pushPose();
        BlockState blockState = Blocks.AIR.defaultBlockState();
        List parts = List.of(AllPartialModels.ENCASED_FAN_INNER.get());
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(FanRenderer.getCurrentAngle() * 16.0f));
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        matrices.pushPose();
        blockState = AllBlocks.ENCASED_FAN.defaultBlockState();
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        matrices.translate(0.0f, 0.0f, 2.0f);
        blockState = state.target();
        FluidState fluidState = blockState.getFluidState();
        if (!fluidState.isEmpty()) {
            Fluid fluid = fluidState.getType();
            FluidRenderHelper.renderFluidBox(fluid, DataComponentPatch.EMPTY, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, (MultiBufferSource)this.bufferSource, matrices, 0xF000F0, false, true);
            return;
        }
        world.blockState(blockState);
        RANDOM.setSeed(blockState.getSeed(BlockPos.ZERO));
        parts = blockRenderManager.getBlockModel(blockState).collectParts(RANDOM);
        if (blockState.getBlock() instanceof BaseFireBlock) {
            buffer = this.bufferSource.getBuffer(RenderTypes.cutoutMovingBlock());
        }
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
    }

    public static float getCurrentAngle() {
        return AnimationTickHolder.getRenderTime() * 4.0f % 360.0f;
    }

    protected String getTextureLabel() {
        return "Fan";
    }

    public Class<FanRenderState> getRenderStateClass() {
        return FanRenderState.class;
    }
}

