/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.SawRenderState;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class SawRenderer
extends PictureInPictureRenderer<SawRenderState> {
    public SawRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(SawRenderState state, PoseStack matrices) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(112.5f));
        matrices.translate(-0.5f, -0.2f, -0.5f);
        matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        matrices.pushPose();
        BlockState blockState = (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
        world.blockState(blockState);
        List<SimpleModelWrapper> parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(SawRenderer.getCurrentAngle()));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, (List)parts);
        matrices.popPose();
        blockState = (BlockState)AllBlocks.MECHANICAL_SAW.defaultBlockState().setValue((Property)SawBlock.FACING, (Comparable)Direction.UP);
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, (List)parts);
        blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE.get());
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, this.bufferSource.getBuffer(RenderTypes.cutoutMovingBlock()), false, parts);
    }

    public static float getCurrentAngle() {
        return -(AnimationTickHolder.getRenderTime() * 4.0f) % 360.0f;
    }

    protected String getTextureLabel() {
        return "Saw";
    }

    public Class<SawRenderState> getRenderStateClass() {
        return SawRenderState.class;
    }
}

