/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.joml.Quaternionfc;

public class SpoutRenderer
extends PictureInPictureRenderer<SpoutRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public SpoutRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(SpoutRenderState item, GuiRenderState state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 26 * windowScaleFactor;
        int height = 65 * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.scale(scale, scale, scale);
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        this.matrices.translate(-0.5f, -0.5f, -0.5f);
        this.matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        float time = AnimationTickHolder.getRenderTime();
        BlockState blockState = AllBlocks.SPOUT.defaultBlockState();
        world.blockState(blockState);
        List parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        float cycle = (time - (float)(item.offset() * 8)) % 30.0f;
        float squeeze = cycle < 20.0f ? -Mth.sin((double)((float)((double)(cycle / 20.0f) * Math.PI))) : 0.0f;
        float move = -3.0f * squeeze / 32.0f;
        blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.SPOUT_TOP.get());
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.pushPose();
        parts = List.of(AllPartialModels.SPOUT_MIDDLE.get());
        this.matrices.translate(0.0f, move, 0.0f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        parts = List.of(AllPartialModels.SPOUT_BOTTOM.get());
        this.matrices.translate(0.0f, move, 0.0f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.popPose();
        this.matrices.pushPose();
        blockState = AllBlocks.DEPOT.defaultBlockState();
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        this.matrices.translate(0.07f, -2.0f, -0.14f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.popPose();
        this.matrices.popPose();
        Fluid fluid = item.fluid();
        if (fluid != Fluids.EMPTY) {
            DataComponentPatch components = item.components();
            this.matrices.pushPose();
            this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
            this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
            float fluidScale = 16 * windowScaleFactor;
            this.matrices.scale(fluidScale, -fluidScale, fluidScale);
            this.matrices.translate(0.0f, -1.4f, 0.0f);
            float from = 0.1875f;
            float to = 1.0625f;
            FluidRenderHelper.renderFluidBox(fluid, components, from, from, from, to, to, to, (MultiBufferSource)this.bufferSource, this.matrices, 0xF000F0, false, true);
            this.matrices.popPose();
            this.matrices.pushPose();
            this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
            this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
            this.matrices.translate(scale / 2.0f, scale * 1.5f, scale / 2.0f);
            this.matrices.scale(fluidScale, -fluidScale, fluidScale);
            this.matrices.translate(-0.5f, -1.0f, -0.5f);
            float fluidWidth = 0.0078125f * -squeeze * 16.0f;
            from = -fluidWidth / 2.0f + 0.5f;
            to = fluidWidth / 2.0f + 0.5f;
            FluidRenderHelper.renderFluidBox(fluid, components, from, 0.0f, from, to, 2.0f, to, (MultiBufferSource)this.bufferSource, this.matrices, 0xF000F0, false, true);
            this.matrices.popPose();
        }
        this.bufferSource.endBatch();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), item.pose(), item.x0(), item.y0(), item.x1(), item.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    protected void renderToTexture(SpoutRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Spout";
    }

    public Class<SpoutRenderState> getRenderStateClass() {
        return SpoutRenderState.class;
    }
}

