/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.item;

import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.item.TooltipModifier;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.goggles.GogglesItem;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.config.CKinetics;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class KineticStats
implements TooltipModifier {
    protected final Block block;

    public KineticStats(Block block) {
        this.block = block;
    }

    @Nullable
    public static KineticStats create(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).getBlock()) instanceof IRotate || block instanceof SteamEngineBlock)) {
            return new KineticStats(block);
        }
        return null;
    }

    @Override
    public void modify(List<Component> tooltip, Player player) {
        List<Component> kineticStats = KineticStats.getKineticStats(this.block, player);
        if (!kineticStats.isEmpty()) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.addAll(kineticStats);
        }
    }

    public static List<Component> getKineticStats(Block block, Player player) {
        boolean hasStressCapacity;
        ArrayList<Component> list = new ArrayList<Component>();
        CKinetics config = AllConfigs.server().kinetics;
        LangBuilder rpmUnit = CreateLang.translate("generic.unit.rpm", new Object[0]);
        LangBuilder suUnit = CreateLang.translate("generic.unit.stress", new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles(player);
        boolean showStressImpact = block instanceof IRotate ? !((IRotate)block).hideStressImpact() : true;
        boolean hasStressImpact = IRotate.StressImpact.isEnabled() && showStressImpact && BlockStressValues.getImpact(block) > 0.0;
        boolean bl = hasStressCapacity = IRotate.StressImpact.isEnabled() && BlockStressValues.getCapacity(block) > 0.0;
        if (hasStressImpact) {
            CreateLang.translate("tooltip.stressImpact", new Object[0]).style(ChatFormatting.GRAY).addTo(list);
            double impact = BlockStressValues.getImpact(block);
            IRotate.StressImpact impactId = impact >= (double)((Float)config.highStressImpact.get()).floatValue() ? IRotate.StressImpact.HIGH : (impact >= (double)((Float)config.mediumStressImpact.get()).floatValue() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            LangBuilder builder = CreateLang.builder().add(CreateLang.text(TooltipHelper.makeProgressBar(3, impactId.ordinal() + 1)).style(impactId.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(CreateLang.number(impact)).text("x ").add(rpmUnit).addTo(list);
            } else {
                builder.translate("tooltip.stressImpact." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        if (hasStressCapacity) {
            CreateLang.translate("tooltip.capacityProvided", new Object[0]).style(ChatFormatting.GRAY).addTo(list);
            double capacity = BlockStressValues.getCapacity(block);
            BlockStressValues.GeneratedRpm generatedRPM = BlockStressValues.RPM.get(block);
            IRotate.StressImpact impactId = capacity >= (double)((Float)config.highCapacity.get()).floatValue() ? IRotate.StressImpact.HIGH : (capacity >= (double)((Float)config.mediumCapacity.get()).floatValue() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
            LangBuilder builder = CreateLang.builder().add(CreateLang.text(TooltipHelper.makeProgressBar(3, impactId.ordinal() + 1)).style(opposite.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(CreateLang.number(capacity)).text("x ").add(rpmUnit).addTo(list);
                if (generatedRPM != null) {
                    LangBuilder amount = CreateLang.number(capacity * (double)generatedRPM.value()).add(suUnit);
                    CreateLang.text(" -> ").add(generatedRPM.mayGenerateLess() ? CreateLang.translate("tooltip.up_to", amount) : amount).style(ChatFormatting.DARK_GRAY).addTo(list);
                }
            } else {
                builder.translate("tooltip.capacityProvided." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        return list;
    }
}

