/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;

public class BakedModelHelper {
    private static long calcSpriteUv(Vec3 diff, long packedUV, Vec3 uAxis, Vec3 vAxis, float uScale, float vScale, TextureAtlasSprite sprite) {
        if (diff.lengthSqr() == 0.0) {
            return packedUV;
        }
        float u = UVPair.unpackU((long)packedUV);
        float v = UVPair.unpackV((long)packedUV);
        u = sprite.getU(SpriteShiftEntry.getUnInterpolatedU(sprite, u) + (float)uAxis.dot(diff) * uScale);
        v = sprite.getV(SpriteShiftEntry.getUnInterpolatedV(sprite, v) + (float)vAxis.dot(diff) * vScale);
        return UVPair.pack((float)u, (float)v);
    }

    public static BakedQuad cropAndMove(BakedQuad quad, AABB crop, Vec3 move) {
        TextureAtlasSprite sprite = quad.sprite();
        Vec3 xyz0 = new Vec3(quad.position0());
        Vec3 xyz1 = new Vec3(quad.position1());
        Vec3 xyz2 = new Vec3(quad.position2());
        Vec3 xyz3 = new Vec3(quad.position3());
        long packedUV0 = quad.packedUV0();
        long packedUV1 = quad.packedUV1();
        long packedUV2 = quad.packedUV2();
        long packedUV3 = quad.packedUV3();
        Vec3 uAxis = xyz3.add(xyz2).scale(0.5);
        Vec3 vAxis = xyz1.add(xyz2).scale(0.5);
        Vec3 center = xyz3.add(xyz2).add(xyz0).add(xyz1).scale(0.25);
        float u0 = UVPair.unpackU((long)packedUV0);
        float u3 = UVPair.unpackU((long)packedUV3);
        float v0 = UVPair.unpackV((long)packedUV0);
        float v1 = UVPair.unpackV((long)packedUV1);
        float uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u3) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz3.distanceTo(xyz0));
        float vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v1) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz1.distanceTo(xyz0));
        if (uScale == 0.0f) {
            float v3 = UVPair.unpackV((long)packedUV3);
            float u1 = UVPair.unpackU((long)packedUV1);
            uAxis = xyz1.add(xyz2).scale(0.5);
            vAxis = xyz3.add(xyz2).scale(0.5);
            uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u1) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz1.distanceTo(xyz0));
            vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v3) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz3.distanceTo(xyz0));
        }
        uAxis = uAxis.subtract(center).normalize();
        vAxis = vAxis.subtract(center).normalize();
        Vec3 min = new Vec3(crop.minX, crop.minY, crop.minZ);
        Vec3 max = new Vec3(crop.maxX, crop.maxY, crop.maxZ);
        Vec3 newXyz0 = VecHelper.componentMin(max, VecHelper.componentMax(xyz0, min));
        Vec3 newXyz1 = VecHelper.componentMin(max, VecHelper.componentMax(xyz1, min));
        Vec3 newXyz2 = VecHelper.componentMin(max, VecHelper.componentMax(xyz2, min));
        Vec3 newXyz3 = VecHelper.componentMin(max, VecHelper.componentMax(xyz3, min));
        BakedQuad newQuad = new BakedQuad((Vector3fc)newXyz0.add(move).toVector3f(), (Vector3fc)newXyz1.add(move).toVector3f(), (Vector3fc)newXyz2.add(move).toVector3f(), (Vector3fc)newXyz3.add(move).toVector3f(), BakedModelHelper.calcSpriteUv(newXyz0.subtract(xyz0), packedUV0, uAxis, vAxis, uScale, vScale, sprite), BakedModelHelper.calcSpriteUv(newXyz1.subtract(xyz1), packedUV1, uAxis, vAxis, uScale, vScale, sprite), BakedModelHelper.calcSpriteUv(newXyz2.subtract(xyz2), packedUV2, uAxis, vAxis, uScale, vScale, sprite), BakedModelHelper.calcSpriteUv(newXyz3.subtract(xyz3), packedUV3, uAxis, vAxis, uScale, vScale, sprite), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    public static SimpleModelWrapper generateModel(SimpleModelWrapper template, UnaryOperator<TextureAtlasSprite> spriteSwapper) {
        QuadCollection.Builder builder = new QuadCollection.Builder();
        for (Direction cullFace : Iterate.directions) {
            List quads = template.getQuads(cullFace);
            BakedModelHelper.swapSprites(quads, spriteSwapper).forEach(quad -> builder.addCulledFace(cullFace, quad));
        }
        List quads = template.getQuads(null);
        BakedModelHelper.swapSprites(quads, spriteSwapper).forEach(arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0));
        TextureAtlasSprite particleSprite = template.particleIcon();
        TextureAtlasSprite swappedParticleSprite = (TextureAtlasSprite)spriteSwapper.apply(particleSprite);
        if (swappedParticleSprite != null) {
            particleSprite = swappedParticleSprite;
        }
        return new SimpleModelWrapper(builder.build(), template.useAmbientOcclusion(), particleSprite);
    }

    public static long calcSpriteUv(long packedUv, TextureAtlasSprite sprite, TextureAtlasSprite newSprite) {
        float u = newSprite.getU(SpriteShiftEntry.getUnInterpolatedU(sprite, UVPair.unpackU((long)packedUv)));
        float v = newSprite.getV(SpriteShiftEntry.getUnInterpolatedV(sprite, UVPair.unpackV((long)packedUv)));
        return UVPair.pack((float)u, (float)v);
    }

    public static List<BakedQuad> swapSprites(List<BakedQuad> quads, UnaryOperator<TextureAtlasSprite> spriteSwapper) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads);
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = quads.get(i);
            TextureAtlasSprite sprite = quad.sprite();
            TextureAtlasSprite newSprite = (TextureAtlasSprite)spriteSwapper.apply(sprite);
            if (newSprite == null || sprite == newSprite) continue;
            BakedQuad newQuad = new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), BakedModelHelper.calcSpriteUv(quad.packedUV0(), sprite, newSprite), BakedModelHelper.calcSpriteUv(quad.packedUV1(), sprite, newSprite), BakedModelHelper.calcSpriteUv(quad.packedUV2(), sprite, newSprite), BakedModelHelper.calcSpriteUv(quad.packedUV3(), sprite, newSprite), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
            NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
            newQuads.set(i, newQuad);
        }
        return newQuads;
    }
}

