/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.ponder;

import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PonderWorldBlockEntityFix {
    public static void fixControllerBlockEntities(PonderLevel world) {
        for (BlockEntity blockEntity : world.getBlockEntities()) {
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity beltBlockEntity = (BeltBlockEntity)blockEntity;
                if (!beltBlockEntity.isController()) continue;
                BlockPos controllerPos = blockEntity.getBlockPos();
                for (BlockPos blockPos : BeltBlock.getBeltChain((LevelReader)world, controllerPos)) {
                    BlockEntity blockEntity2 = world.getBlockEntity(blockPos);
                    if (!(blockEntity2 instanceof BeltBlockEntity)) continue;
                    BeltBlockEntity belt2 = (BeltBlockEntity)blockEntity2;
                    belt2.setController(controllerPos);
                }
            }
            if (!(blockEntity instanceof IMultiBlockEntityContainer)) continue;
            IMultiBlockEntityContainer multiBlockEntity = (IMultiBlockEntityContainer)blockEntity;
            BlockPos lastKnown = multiBlockEntity.getLastKnownPos();
            BlockPos current = blockEntity.getBlockPos();
            if (lastKnown == null || current == null || multiBlockEntity.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = multiBlockEntity.getController().offset((Vec3i)current.subtract((Vec3i)lastKnown));
            multiBlockEntity.setController(newControllerPos);
        }
    }
}

