/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockEntityRenderHelper {
    @Nullable
    public static BlockEntityListRenderState getBlockEntitiesRenderState(boolean supportsVisualization, List<BlockEntity> blockEntities, BitSet shouldRenderBEs, BitSet erroredBEsOut, @Nullable VirtualRenderWorld renderLevel, Level realLevel, PoseStack ms, @Nullable Matrix4f lightTransform, Vec3 camera, float pt) {
        int size = blockEntities.size();
        if (size == 0) {
            return null;
        }
        Minecraft mc = Minecraft.getInstance();
        BlockEntityRenderDispatcher dispatcher = mc.getBlockEntityRenderDispatcher();
        ArrayList<BlockEntityRenderState> states = new ArrayList<BlockEntityRenderState>();
        int i = shouldRenderBEs.nextSetBit(0);
        while (i >= 0 && i < size) {
            BlockEntity blockEntity = blockEntities.get(i);
            if (!supportsVisualization || !VisualizationHelper.skipVanillaRender(blockEntity)) {
                BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
                if (renderer == null) {
                    erroredBEsOut.set(i);
                } else {
                    try {
                        BlockEntityRenderState renderState = renderer.createRenderState();
                        int realLevelLight = LevelRenderer.getLightColor((BlockAndTintGetter)realLevel, (BlockPos)BlockEntityRenderHelper.getLightPos(lightTransform, blockEntity.getBlockPos()));
                        if (renderLevel != null) {
                            renderLevel.setExternalLight(realLevelLight);
                        }
                        renderer.extractRenderState(blockEntity, renderState, pt, camera, null);
                        if (renderLevel == null) {
                            renderState.lightCoords = realLevelLight;
                        }
                        states.add(renderState);
                    }
                    catch (Exception e) {
                        erroredBEsOut.set(i);
                        String message = "BlockEntity " + String.valueOf(RegisteredObjectsHelper.getKeyOrThrow(blockEntity.getType())) + " could not be rendered virtually.";
                        if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                            Create.LOGGER.error(message, (Throwable)e);
                        }
                        Create.LOGGER.error(message);
                    }
                }
            }
            i = shouldRenderBEs.nextSetBit(i + 1);
        }
        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
        if (states.isEmpty()) {
            return null;
        }
        return new BlockEntityListRenderState(dispatcher, ms, camera, BlockPos.containing((Position)camera), states);
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.getX() + 0.5f, (float)contraptionPos.getY() + 0.5f, (float)contraptionPos.getZ() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.containing((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }

    public record BlockEntityListRenderState(BlockEntityRenderDispatcher dispatcher, PoseStack matrices, Vec3 camera, BlockPos cameraPos, List<BlockEntityRenderState> states) {
        public void render(SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
            Vec3 prevPos = cameraRenderState.pos;
            BlockPos prevBlockPos = cameraRenderState.blockPos;
            Vec3 prevEntityPos = cameraRenderState.entityPos;
            cameraRenderState.pos = this.camera;
            cameraRenderState.blockPos = this.cameraPos;
            cameraRenderState.entityPos = new Vec3(prevEntityPos.x - prevPos.x + this.camera.x, prevEntityPos.y - prevPos.y + this.camera.y, prevEntityPos.z - prevPos.z + this.camera.z);
            for (BlockEntityRenderState state : this.states) {
                BlockEntityRenderer renderer = this.dispatcher.getRenderer(state);
                if (renderer == null) continue;
                BlockPos pos = state.blockPos;
                this.matrices.pushPose();
                this.matrices.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                renderer.submit(state, this.matrices, queue, cameraRenderState);
                this.matrices.popPose();
            }
            cameraRenderState.pos = prevPos;
            cameraRenderState.blockPos = prevBlockPos;
            cameraRenderState.entityPos = prevEntityPos;
        }
    }
}

