/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.zurrtum.create.client.foundation.render.AllRenderPipelines;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;

public class CreateRenderTypes {
    private static final RenderType TRANSLUCENT = RenderType.create((String)CreateRenderTypes.createLayerName("translucent"), (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TRANSLUCENT_MOVING_BLOCK).bufferSize(256).affectsCrumbling().sortOnUpload().useLightmap().withTexture("Sampler0", TextureAtlas.LOCATION_BLOCKS, RenderTypes.MOVING_BLOCK_SAMPLER).setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
    private static final RenderType ADDITIVE = RenderType.create((String)CreateRenderTypes.createLayerName("additive"), (RenderSetup)RenderSetup.builder((RenderPipeline)AllRenderPipelines.ADDITIVE).bufferSize(256).affectsCrumbling().sortOnUpload().withTexture("Sampler0", TextureAtlas.LOCATION_BLOCKS).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
    private static final RenderType ADDITIVE2 = RenderType.create((String)CreateRenderTypes.createLayerName("additive2"), (RenderSetup)RenderSetup.builder((RenderPipeline)AllRenderPipelines.ADDITIVE2).bufferSize(256).affectsCrumbling().sortOnUpload().withTexture("Sampler0", TextureAtlas.LOCATION_BLOCKS).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
    private static final RenderType ITEM_GLOWING_SOLID = RenderType.create((String)CreateRenderTypes.createLayerName("item_glowing_solid"), (RenderSetup)RenderSetup.builder((RenderPipeline)AllRenderPipelines.GLOWING).bufferSize(256).affectsCrumbling().withTexture("Sampler0", TextureAtlas.LOCATION_BLOCKS).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
    private static final RenderType ITEM_GLOWING_TRANSLUCENT = RenderType.create((String)CreateRenderTypes.createLayerName("item_glowing_translucent"), (RenderSetup)RenderSetup.builder((RenderPipeline)AllRenderPipelines.GLOWING_TRANSLUCENT).bufferSize(256).affectsCrumbling().sortOnUpload().withTexture("Sampler0", TextureAtlas.LOCATION_BLOCKS).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup());
    public static final Supplier<GpuSampler> CHAIN_SAMPLER = () -> RenderSystem.getSamplerCache().getSampler(AddressMode.REPEAT, AddressMode.REPEAT, FilterMode.LINEAR, FilterMode.NEAREST, true);
    private static final Function<Identifier, RenderType> CHAIN = Util.memoize(texture -> RenderType.create((String)"chain_conveyor_chain", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.CUTOUT_BLOCK).sortOnUpload().withTexture("Sampler0", texture, CHAIN_SAMPLER).useLightmap().useOverlay().setOutline(RenderSetup.OutlineProperty.AFFECTS_OUTLINE).createRenderSetup()));
    public static BiFunction<Identifier, Boolean, RenderType> TRAIN_MAP = Util.memoize(CreateRenderTypes::getTrainMap);

    public static RenderType translucent() {
        return TRANSLUCENT;
    }

    public static RenderType additive() {
        return ADDITIVE;
    }

    public static RenderType additive2() {
        return ADDITIVE2;
    }

    private static RenderType getTrainMap(Identifier locationIn, boolean linearFiltering) {
        return RenderType.create((String)"create_train_map", (RenderSetup)RenderSetup.builder((RenderPipeline)RenderPipelines.TEXT).bufferSize(256).sortOnUpload().useLightmap().withTexture("Sampler0", locationIn, () -> RenderSystem.getSamplerCache().getClampToEdge(linearFiltering ? FilterMode.LINEAR : FilterMode.NEAREST)).createRenderSetup());
    }

    public static RenderType itemGlowingSolid() {
        return ITEM_GLOWING_SOLID;
    }

    public static RenderType itemGlowingTranslucent() {
        return ITEM_GLOWING_TRANSLUCENT;
    }

    public static RenderType chain(Identifier pLocation) {
        return CHAIN.apply(pLocation);
    }

    private static String createLayerName(String name) {
        return "create:" + name;
    }
}

