/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.sound;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.sound.SoundScape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class RepeatingSound {
    private final SoundEvent event;
    private final float sharedPitch;
    private final int repeatDelay;
    private final SoundScape scape;
    private final float relativeVolume;

    public RepeatingSound(SoundEvent event, SoundScape scape, float sharedPitch, float relativeVolume, int repeatDelay) {
        this.event = event;
        this.scape = scape;
        this.sharedPitch = sharedPitch;
        this.relativeVolume = relativeVolume;
        this.repeatDelay = Math.max(1, repeatDelay);
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % this.repeatDelay != 0) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        Vec3 meanPos = this.scape.getMeanPos();
        world.playLocalSound(meanPos.x, meanPos.y, meanPos.z, this.event, SoundSource.AMBIENT, this.scape.getVolume() * this.relativeVolume, this.sharedPitch, true);
    }
}

