/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import java.util.List;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BeltModel
extends WrapperBlockStateModel {
    private static final SpriteShiftEntry SPRITE_SHIFT = AllSpriteShifts.ANDESIDE_BELT_CASING;

    public BeltModel(BlockState state, BlockStateModel.UnbakedRoot unbaked) {
        super(state, unbaked);
    }

    @Override
    public TextureAtlasSprite particleSpriteWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BeltBlockEntity) {
            BeltBlockEntity blockEntity2 = (BeltBlockEntity)blockEntity;
            if (blockEntity2.casing == BeltBlockEntity.CasingType.ANDESITE) {
                return AllSpriteShifts.ANDESITE_CASING.getOriginal();
            }
        }
        return this.model.particleIcon();
    }

    @Override
    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        BeltBlockEntity blockentity = (BeltBlockEntity)world.getBlockEntity(pos);
        if (blockentity == null || blockentity.casing == BeltBlockEntity.CasingType.NONE) {
            this.model.collectParts(random, parts);
            return;
        }
        if (blockentity.casing == BeltBlockEntity.CasingType.BRASS) {
            this.model.collectParts(random, parts);
            if (blockentity.covered) {
                boolean alongX = ((Direction)state.getValue((Property)BeltBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X;
                parts.add((BlockModelPart)(alongX ? AllPartialModels.BRASS_BELT_COVER_X.get() : AllPartialModels.BRASS_BELT_COVER_Z.get()));
            }
            return;
        }
        TextureAtlasSprite original = SPRITE_SHIFT.getOriginal();
        if (blockentity.covered) {
            boolean alongX = ((Direction)state.getValue((Property)BeltBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X;
            parts.add(this.replaceQuads(original, (BlockModelPart)(alongX ? AllPartialModels.ANDESITE_BELT_COVER_X.get() : AllPartialModels.ANDESITE_BELT_COVER_Z.get())));
        }
        for (BlockModelPart part : this.model.collectParts(random)) {
            parts.add(this.replaceQuads(original, part));
        }
    }

    private BlockModelPart replaceQuads(TextureAtlasSprite replace, BlockModelPart part) {
        QuadCollection.Builder builder = new QuadCollection.Builder();
        for (BakedQuad quad : part.getQuads(null)) {
            builder.addUnculledFace(this.replaceQuad(replace, quad));
        }
        for (Direction direction : Iterate.directions) {
            for (BakedQuad quad : part.getQuads(direction)) {
                builder.addCulledFace(direction, this.replaceQuad(replace, quad));
            }
        }
        return new SimpleModelWrapper(builder.build(), part.useAmbientOcclusion(), part.particleIcon());
    }

    private static long calcSpriteUv(long packedUv) {
        float u = UVPair.unpackU((long)packedUv);
        float v = UVPair.unpackV((long)packedUv);
        return UVPair.pack((float)SPRITE_SHIFT.getTargetU(u), (float)SPRITE_SHIFT.getTargetV(v));
    }

    private BakedQuad replaceQuad(TextureAtlasSprite replace, BakedQuad quad) {
        TextureAtlasSprite original = quad.sprite();
        if (original != replace) {
            return quad;
        }
        BakedQuad newQuad = new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), BeltModel.calcSpriteUv(quad.packedUV0()), BeltModel.calcSpriteUv(quad.packedUV1()), BeltModel.calcSpriteUv(quad.packedUV2()), BeltModel.calcSpriteUv(quad.packedUV3()), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }
}

