/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class CardboardSwordModel
implements ItemModel {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/cardboard_sword");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/cardboard_sword/item");
    public static final Identifier BLOCK_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/cardboard_sword/item_in_hand");
    private final RenderType layer = Sheets.translucentItemSheet();
    private final List<BakedQuad> itemQuads;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<BakedQuad> blockQuads;
    private final Supplier<Vector3fc[]> blockVector;
    private final ModelRenderProperties settings;

    public CardboardSwordModel(List<BakedQuad> item, List<BakedQuad> block, ModelRenderProperties settings) {
        this.itemQuads = item;
        this.itemVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.itemQuads));
        this.blockQuads = block;
        this.blockVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.blockQuads));
        this.settings = settings;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        state.appendModelIdentityElement((Object)this);
        if (displayContext == ItemDisplayContext.GUI) {
            this.update(state, displayContext, this.itemQuads, this.settings, this.itemVector);
        } else {
            this.update(state, displayContext, this.blockQuads, this.settings, this.blockVector);
        }
    }

    private void update(ItemStackRenderState state, ItemDisplayContext displayContext, List<BakedQuad> quads, ModelRenderProperties settings, Supplier<Vector3fc[]> vector) {
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        layerRenderState.setRenderType(this.layer);
        layerRenderState.setExtents(vector);
        settings.applyToLayer(layerRenderState, displayContext);
        layerRenderState.prepareQuadList().addAll(quads);
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(BLOCK_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel itemModel = baker.getModel(ITEM_ID);
            TextureSlots itemTextures = itemModel.getTopTextureSlots();
            List itemQuads = itemModel.bakeTopGeometry(itemTextures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)itemModel, (TextureSlots)itemTextures);
            ResolvedModel blockModel = baker.getModel(BLOCK_ID);
            List blockQuads = blockModel.bakeTopGeometry(blockModel.getTopTextureSlots(), baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            return new CardboardSwordModel(itemQuads, blockQuads, settings);
        }
    }
}

