/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoCannonItem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class PotatoCannonModel
implements ItemModel,
SpecialModelRenderer<CogRenderData> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/potato_cannon");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/potato_cannon/item");
    public static final Identifier COG_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/potato_cannon/cog");
    private final RenderType layer = Sheets.translucentItemSheet();
    private final List<BakedQuad> itemQuads;
    private final ModelRenderProperties itemSettings;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<BakedQuad> cogQuads;
    private final ModelRenderProperties cogSettings;
    private final Supplier<Vector3fc[]> cogVector;

    public PotatoCannonModel(Tuple<List<BakedQuad>, ModelRenderProperties> item, Tuple<List<BakedQuad>, ModelRenderProperties> cog) {
        this.itemQuads = (List)item.getA();
        this.itemSettings = (ModelRenderProperties)item.getB();
        this.itemVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.itemQuads));
        this.cogQuads = (List)cog.getA();
        this.cogSettings = (ModelRenderProperties)cog.getB();
        this.cogVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.cogQuads));
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        LocalPlayer player;
        boolean inMainHand;
        ItemStackRenderState.FoilType glint;
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        if (stack.hasFoil()) {
            state.appendModelIdentityElement((Object)ItemStackRenderState.FoilType.STANDARD);
            glint = ItemStackRenderState.FoilType.STANDARD;
        } else {
            glint = ItemStackRenderState.FoilType.NONE;
        }
        this.update(state, displayContext, this.itemQuads, this.itemSettings, this.itemVector, glint);
        CogRenderData cog = new CogRenderData();
        cog.state = this.update(state, displayContext, this.cogQuads, this.cogSettings, this.cogVector, glint);
        cog.state.setTransform(this.itemSettings.transforms().getTransform(displayContext));
        cog.rotation = AnimationTickHolder.getRenderTime() * -2.5f;
        boolean bl = inMainHand = displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        if ((inMainHand || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) && (player = Minecraft.getInstance().player) != null) {
            boolean leftHanded = player.getMainArm() == HumanoidArm.LEFT;
            float speed = Create.POTATO_CANNON_RENDER_HANDLER.getAnimation(inMainHand ^ leftHanded, AnimationTickHolder.getPartialTicks());
            cog.rotation += 360.0f * Mth.clamp((float)(speed * 5.0f), (float)0.0f, (float)1.0f);
        }
        cog.rotation %= 360.0f;
        cog.state.setupSpecialModel((SpecialModelRenderer)this, (Object)cog);
    }

    private ItemStackRenderState.LayerRenderState update(ItemStackRenderState state, ItemDisplayContext displayContext, List<BakedQuad> quads, ModelRenderProperties settings, Supplier<Vector3fc[]> vector, ItemStackRenderState.FoilType glint) {
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        layerRenderState.setRenderType(this.layer);
        layerRenderState.setExtents(vector);
        settings.applyToLayer(layerRenderState, displayContext);
        layerRenderState.prepareQuadList().addAll(quads);
        layerRenderState.setFoilType(glint);
        return layerRenderState;
    }

    public void submit(CogRenderData data, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        matrices.translate(0.5f, 0.53125f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(data.rotation));
        matrices.translate(-0.5f, -0.53125f, -0.5f);
        ItemStackRenderState.LayerRenderState state = data.state;
        queue.submitItem(matrices, displayContext, light, overlay, 0, state.tintLayers, state.quads, state.renderType, state.foilType);
    }

    public static void renderDecorator(Minecraft client, GuiGraphics drawContext, ItemStack stack, int x, int y) {
        if (client.player == null) {
            return;
        }
        PotatoCannonItem.Ammo ammo = PotatoCannonItem.getAmmo((Player)client.player, stack);
        if (ammo == null) {
            return;
        }
        Matrix3x2fStack matrices = drawContext.pose();
        matrices.translate((float)x, (float)(y + 8));
        matrices.scale(0.5f);
        drawContext.renderItem(ammo.stack(), 0, 0);
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public CogRenderData extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class CogRenderData {
        ItemStackRenderState.LayerRenderState state;
        float rotation;
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(COG_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            return new PotatoCannonModel(Unbaked.bake(baker, ITEM_ID), Unbaked.bake(baker, COG_ID));
        }

        private static Tuple<List<BakedQuad>, ModelRenderProperties> bake(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new Tuple((Object)quads, (Object)settings);
        }
    }
}

