/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class SandPaperModel
implements ItemModel,
SpecialModelRenderer<RenderData> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/sand_paper");
    private final RenderType layer = Sheets.translucentItemSheet();
    private final List<BakedQuad> quads;
    private final ModelRenderProperties settings;
    private final Supplier<Vector3fc[]> vector;

    public SandPaperModel(List<BakedQuad> quads, ModelRenderProperties settings) {
        this.quads = quads;
        this.settings = settings;
        this.vector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.quads));
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner ctx, int seed) {
        Player entity;
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        layerRenderState.setRenderType(this.layer);
        layerRenderState.setExtents(this.vector);
        this.settings.applyToLayer(layerRenderState, displayContext);
        layerRenderState.prepareQuadList().addAll(this.quads);
        RenderData data = new RenderData();
        data.state = layerRenderState;
        if (ctx instanceof Player) {
            Player player = (Player)ctx;
            data.itemInUseCount = player.getUseItemRemainingTicks();
            entity = player;
        } else {
            LocalPlayer player = Minecraft.getInstance().player;
            data.itemInUseCount = player.getUseItemRemainingTicks();
            entity = player;
        }
        SandPaperItemComponent component = (SandPaperItemComponent)stack.get(AllDataComponents.SAND_PAPER_POLISHING);
        if (component != null) {
            int maxUseTime = stack.getUseDuration((LivingEntity)entity);
            boolean jeiMode = stack.has(AllDataComponents.SAND_PAPER_JEI);
            float partialTicks = AnimationTickHolder.getPartialTicks();
            float time = (float)(!jeiMode ? data.itemInUseCount : -AnimationTickHolder.getTicks() % maxUseTime) - partialTicks + 1.0f;
            boolean bl = data.reverseBobbing = time / (float)maxUseTime < 0.8f;
            if (data.reverseBobbing) {
                data.bobbing = -Mth.abs((float)(Mth.cos((double)(time / 4.0f * (float)Math.PI)) * 0.1f));
            }
            ItemStack toPolish = component.item();
            data.item = new ItemStackRenderState();
            data.item.displayContext = displayContext;
            resolver.appendItemLayers(data.item, toPolish, ItemDisplayContext.GUI, (Level)world, ctx, seed);
        }
        layerRenderState.setupSpecialModel((SpecialModelRenderer)this, (Object)data);
    }

    public void submit(RenderData data, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        int modifier;
        assert (data != null);
        ItemStackRenderState.LayerRenderState state = data.state;
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        boolean firstPerson = leftHand || displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        matrices.pushPose();
        if (firstPerson && data.itemInUseCount > 0) {
            modifier = leftHand ? -1 : 1;
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.translate((float)modifier * 0.5f, 0.0f, -0.25f);
            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(modifier * 40)));
            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)(modifier * 10)));
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(modifier * 90)));
            matrices.translate(-0.5f, -0.5f, -0.5f);
        }
        queue.submitItem(matrices, displayContext, light, overlay, 0, state.tintLayers, state.quads, state.renderType, state.foilType);
        matrices.popPose();
        if (data.item == null) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        if (displayContext == ItemDisplayContext.GUI) {
            matrices.translate(0.0f, 0.2f, 1.0f);
            matrices.scale(0.75f, 0.75f, 0.75f);
        } else {
            modifier = leftHand ? -1 : 1;
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(modifier * 40)));
        }
        if (data.reverseBobbing) {
            if (displayContext == ItemDisplayContext.GUI) {
                matrices.translate(data.bobbing, data.bobbing, 0.0f);
            } else {
                matrices.translate(0.0f, data.bobbing, 0.0f);
            }
        }
        data.item.submit(matrices, queue, light, overlay, 0);
        matrices.popPose();
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class RenderData {
        ItemStackRenderState.LayerRenderState state;
        ItemStackRenderState item;
        int itemInUseCount;
        boolean reverseBobbing;
        float bobbing;
    }

    public record Unbaked(Identifier model) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("model").forGetter(Unbaked::model)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.model);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel model = baker.getModel(this.model);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new SandPaperModel(quads, settings);
        }
    }
}

