/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TableClothModel
extends WrapperBlockStateModel {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
    private static final int SOUTH_WEST = 3;
    private static final int NORTH_WEST = 6;
    private static final int NORTH_EAST = 12;
    private static final int SOUTH_EAST = 9;
    private final BakedCorner[] corner = new BakedCorner[16];
    private List<BakedQuad> south;
    private List<BakedQuad> west;
    private List<BakedQuad> north;
    private List<BakedQuad> east;

    public TableClothModel(BlockState state, BlockStateModel.UnbakedRoot unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        this.model.collectParts(random, parts);
        int index = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 4; ++i) {
            Direction direction = DIRECTIONS[i];
            if (!Block.shouldRenderFace((BlockState)state, (BlockState)world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction)), (Direction)direction)) continue;
            index |= 1 << i;
        }
        BakedCorner cache = this.corner[index];
        if (cache != null) {
            parts.add(cache);
            return;
        }
        TextureAtlasSprite sprite = this.model.particleIcon();
        this.corner[index] = new BakedCorner((index & 3) == 3 ? this.getSouth(sprite) : List.of(), (index & 6) == 6 ? this.getWest(sprite) : List.of(), (index & 0xC) == 12 ? this.getNorth(sprite) : List.of(), (index & 9) == 9 ? this.getEast(sprite) : List.of(), sprite);
        parts.add(this.corner[index]);
    }

    private List<BakedQuad> getSouth(TextureAtlasSprite sprite) {
        if (this.south != null) {
            return this.south;
        }
        this.south = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SW);
        return this.south;
    }

    private List<BakedQuad> getWest(TextureAtlasSprite sprite) {
        if (this.west != null) {
            return this.west;
        }
        this.west = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NW);
        return this.west;
    }

    private List<BakedQuad> getNorth(TextureAtlasSprite sprite) {
        if (this.north != null) {
            return this.north;
        }
        this.north = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NE);
        return this.north;
    }

    private List<BakedQuad> getEast(TextureAtlasSprite sprite) {
        if (this.east != null) {
            return this.east;
        }
        this.east = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SE);
        return this.east;
    }

    private static List<BakedQuad> replaceQuads(TextureAtlasSprite replace, PartialModel model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : model.get().quads().getAll()) {
            builder.add((Object)TableClothModel.replaceQuad(replace, quad));
        }
        return builder.build();
    }

    private static BakedQuad replaceQuad(TextureAtlasSprite replace, BakedQuad quad) {
        TextureAtlasSprite original = quad.sprite();
        if (original == replace) {
            return quad;
        }
        BakedQuad newQuad = new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), BakedModelHelper.calcSpriteUv(quad.packedUV0(), original, replace), BakedModelHelper.calcSpriteUv(quad.packedUV1(), original, replace), BakedModelHelper.calcSpriteUv(quad.packedUV2(), original, replace), BakedModelHelper.calcSpriteUv(quad.packedUV3(), original, replace), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    private record BakedCorner(List<BakedQuad> south, List<BakedQuad> west, List<BakedQuad> north, List<BakedQuad> east, TextureAtlasSprite particleIcon) implements BlockModelPart
    {
        public List<BakedQuad> getQuads(@Nullable Direction side) {
            Direction direction = side;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SOUTH", "WEST", "NORTH", "EAST"}, (Direction)direction, n)) {
                case 0 -> this.south;
                case 1 -> this.west;
                case 2 -> this.north;
                case 3 -> this.east;
                default -> List.of();
            };
        }

        public boolean useAmbientOcclusion() {
            return false;
        }
    }
}

