/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class WrenchModel
implements ItemModel,
SpecialModelRenderer<ItemStackRenderState.LayerRenderState> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/wrench");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/wrench/item");
    public static final Identifier GEAR_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/wrench/gear");
    private final RenderType layer = Sheets.translucentItemSheet();
    private final List<BakedQuad> itemQuads;
    private final ModelRenderProperties itemSettings;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<BakedQuad> gearQuads;
    private final ModelRenderProperties gearSettings;
    private final Supplier<Vector3fc[]> gearVector;

    public WrenchModel(Tuple<List<BakedQuad>, ModelRenderProperties> item, Tuple<List<BakedQuad>, ModelRenderProperties> gear) {
        this.itemQuads = (List)item.getA();
        this.itemSettings = (ModelRenderProperties)item.getB();
        this.itemVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.itemQuads));
        this.gearQuads = (List)gear.getA();
        this.gearSettings = (ModelRenderProperties)gear.getB();
        this.gearVector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents(this.gearQuads));
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        this.update(state, displayContext, this.itemQuads, this.itemSettings, this.itemVector, false);
        this.update(state, displayContext, this.gearQuads, this.gearSettings, this.gearVector, true);
    }

    private void update(ItemStackRenderState state, ItemDisplayContext displayContext, List<BakedQuad> quads, ModelRenderProperties settings, Supplier<Vector3fc[]> vector, boolean rotation) {
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        layerRenderState.setRenderType(this.layer);
        layerRenderState.setExtents(vector);
        settings.applyToLayer(layerRenderState, displayContext);
        layerRenderState.prepareQuadList().addAll(quads);
        if (rotation) {
            layerRenderState.setupSpecialModel((SpecialModelRenderer)this, (Object)layerRenderState);
        }
    }

    public void submit(ItemStackRenderState.LayerRenderState layer, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        assert (layer != null);
        matrices.pushPose();
        matrices.translate(0.5625f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(ScrollValueHandler.getScroll(AnimationTickHolder.getPartialTicks())));
        matrices.translate(-0.5625f, -0.5f, -0.5f);
        queue.submitItem(matrices, displayContext, light, overlay, 0, layer.tintLayers, layer.quads, layer.renderType, layer.foilType);
        matrices.popPose();
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public ItemStackRenderState.LayerRenderState extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(GEAR_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            return new WrenchModel(Unbaked.bake(baker, ITEM_ID), Unbaked.bake(baker, GEAR_ID));
        }

        private static Tuple<List<BakedQuad>, ModelRenderProperties> bake(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new Tuple((Object)quads, (Object)settings);
        }
    }
}

