/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.client.infrastructure.particle.SoulBaseParticle;
import com.zurrtum.create.client.infrastructure.particle.SoulParticle;
import com.zurrtum.create.client.infrastructure.particle.WiFiParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class BasicParticleFactory
implements ParticleProvider<SimpleParticleType> {
    private final Factory factory;
    private SpriteSet spriteSet;

    private BasicParticleFactory(Factory factory, SpriteSet spriteSet) {
        this.factory = factory;
        this.spriteSet = spriteSet;
    }

    public static ParticleProvider<SimpleParticleType> wifi(SpriteSet spriteSet) {
        return new BasicParticleFactory(WiFiParticle::new, spriteSet);
    }

    public static ParticleProvider<SimpleParticleType> soul(SpriteSet spriteSet) {
        return new BasicParticleFactory(SoulParticle::new, spriteSet);
    }

    public static ParticleProvider<SimpleParticleType> soulBase(SpriteSet spriteSet) {
        return new BasicParticleFactory(SoulBaseParticle::new, spriteSet);
    }

    public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, RandomSource random) {
        return this.factory.createParticle(parameters, this.spriteSet, world, x, y, z, velocityX, velocityY, velocityZ, random);
    }

    @FunctionalInterface
    public static interface Factory {
        public Particle createParticle(SimpleParticleType var1, SpriteSet var2, ClientLevel var3, double var4, double var6, double var8, double var10, double var12, double var14, RandomSource var16);
    }
}

