/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.math.Axis;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CustomRotationParticle
extends SimpleAnimatedParticle {
    protected boolean mirror;
    protected int loopLength;

    public CustomRotationParticle(ClientLevel worldIn, double x, double y, double z, SpriteSet spriteSet, float yAccel) {
        super(worldIn, x, y, z, spriteSet, yAccel);
    }

    public void selectSpriteLoopingWithAge(SpriteSet sprite) {
        int loopFrame = this.age % this.loopLength;
        this.setSprite(sprite.get(loopFrame, this.loopLength));
    }

    public Quaternionf getCustomRotation(Camera camera, float partialTicks) {
        Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.rotation());
        if (this.roll != 0.0f) {
            float angle = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(angle));
        }
        return quaternion;
    }

    public void extract(QuadParticleRenderState submittable, Camera camera, float partialTicks) {
        Vec3 cameraPos = camera.position();
        float originX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float originY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float originZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        Quaternionf rotation = this.getCustomRotation(camera, partialTicks);
        submittable.add(this.getLayer(), originX, originY, originZ, rotation.x, rotation.y, rotation.z, rotation.w, this.getQuadSize(partialTicks), this.mirror ? this.getU1() : this.getU0(), this.mirror ? this.getU0() : this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), ShadersModHelper.isShaderPackInUse() ? LightTexture.pack((int)12, (int)15) : this.getLightColor(partialTicks));
    }
}

