/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.math.Axis;
import com.zurrtum.create.client.content.equipment.bell.SoulPulseEffect;
import com.zurrtum.create.client.infrastructure.particle.CustomRotationParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class SoulBaseParticle
extends CustomRotationParticle {
    public SoulBaseParticle(SimpleParticleType parameters, SpriteSet spriteSet, ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
        super(worldIn, x, y, z, spriteSet, 0.0f);
        this.quadSize = 0.5f;
        this.setSize(this.quadSize, this.quadSize);
        this.loopLength = 16 + (int)(random.nextFloat() * 2.0f - 1.0f);
        this.lifetime = (int)(90.0f / (random.nextFloat() * 0.36f + 0.64f));
        this.selectSpriteLoopingWithAge(this.sprites);
        this.stoppedByCollision = true;
    }

    public void tick() {
        this.selectSpriteLoopingWithAge(this.sprites);
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.age++ >= this.lifetime || !SoulPulseEffect.isDark((Level)this.level, pos)) {
            this.remove();
        }
    }

    @Override
    public Quaternionf getCustomRotation(Camera camera, float partialTicks) {
        return Axis.XP.rotationDegrees(-90.0f);
    }
}

