/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.impl.visualization.VisualizationEventHandler;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public class ClientLevelMixin {
    @Inject(method={"onBlockEntityAdded(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z")}, cancellable=true)
    private void flywheel$decideNotToRenderEntity(BlockEntity entity, CallbackInfo ci) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)entity.getLevel()) && VisualizationHelper.skipVanillaRender(entity)) {
            ci.cancel();
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onLoadWorld(CallbackInfo ci) {
        Create.SCHEMATIC_HANDLER.updateRenderers();
        com.zurrtum.create.Create.REDSTONE_LINK_NETWORK_HANDLER.onLoadWorld((LevelAccessor)((Level)this));
    }

    @Inject(method={"addEntity(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void addEntity(CallbackInfo ci, @Local(argsOnly=true) Entity entity) {
        ClientLevel world = (ClientLevel)this;
        VisualizationEventHandler.onEntityJoinLevel((Level)world, entity);
        ContraptionHandlerClient.addSpawnedContraptionsToCollisionList(entity, (Level)world);
        CapabilityMinecartController.attach((EntityAccess)entity);
    }

    @Inject(method={"tickNonPassenger(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private void tickEntity(Entity entity, CallbackInfo ci) {
        CapabilityMinecartController.entityTick(entity);
        DivingBootsItem.accelerateDescentUnderwater(entity);
        CardboardArmorHandler.mobsMayLoseTargetWhenItIsWearingCardboard(entity);
    }
}

