/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.SharedConstants;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPackSource.class})
public abstract class ClientPackSourceMixin {
    @Inject(method={"populatePackList(Ljava/util/function/BiConsumer;)V"}, at={@At(value="TAIL")})
    private void loadResourcePack(BiConsumer<String, Function<String, Pack>> consumer, CallbackInfo ci) {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("create").orElseThrow();
        consumer.accept("create", id -> {
            ModMetadata metadata = mod.getMetadata();
            PackLocationInfo info = new PackLocationInfo(id, Component.nullToEmpty((String)metadata.getName()), PackSource.BUILT_IN, Optional.of(new KnownPack(id, "assets", metadata.getVersion().getFriendlyString())));
            PackType type = PackType.CLIENT_RESOURCES;
            BuiltInMetadata metadataMap = BuiltInMetadata.of((MetadataSectionType)PackMetadataSection.CLIENT_TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)"advancement.create.root"), SharedConstants.getCurrentVersion().packVersion(type).minorRange()));
            VanillaPackResourcesBuilder builder = new VanillaPackResourcesBuilder().setMetadata(metadataMap).exposeNamespace(new String[]{id, "minecraft", "flywheel", "vanillin", "ponder", "fabric"});
            String directory = type.getDirectory();
            for (Path path : mod.getRootPaths()) {
                builder.pushAssetPath(type, path.resolve(directory));
            }
            final VanillaPackResources pack = builder.build(info);
            Pack.ResourcesSupplier packFactory = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo info) {
                    return pack;
                }

                public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                    return pack;
                }
            };
            PackSelectionConfig position = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);
            return Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)packFactory, (PackType)type, (PackSelectionConfig)position);
        });
    }
}

