/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeGuiComponents;
import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeInventoryScreen;
import com.zurrtum.create.infrastructure.itemGroup.FabricItemGroupImpl;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeModeInventoryScreenMixin
extends AbstractContainerScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements FabricCreativeInventoryScreen {
    @Shadow
    private static CreativeModeTab selectedTab;
    @Unique
    private static int currentPage;

    public CreativeModeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void selectTab(CreativeModeTab var1);

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setTextColor(I)V", shift=At.Shift.AFTER)})
    private void init(CallbackInfo info) {
        currentPage = this.fabric_getPage(selectedTab);
        int xpos = this.leftPos + 171;
        int ypos = this.topPos + 4;
        this.addRenderableWidget((GuiEventListener)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 10, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.addRenderableWidget((GuiEventListener)new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"selectTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(CreativeModeTab itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"checkTabHovering"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(GuiGraphics drawContext, CreativeModeTab itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkTabClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void isClickInTab(CreativeModeTab itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabButton"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(GuiGraphics graphics, int mouseX, int mouseY, CreativeModeTab itemGroup, CallbackInfo info) {
        if (!this.isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(KeyEvent input, CallbackInfoReturnable<Boolean> cir) {
        int keyCode = input.key();
        if (keyCode == 266) {
            if (this.fabric_switchToPreviousPage()) {
                cir.setReturnValue((Object)true);
            }
        } else if (keyCode == 267 && this.fabric_switchToNextPage()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public int fabric_getCurrentPage() {
        return currentPage;
    }

    @Override
    public boolean fabric_switchToPage(int page) {
        if (!this.hasGroupForPage(page)) {
            return false;
        }
        if (currentPage == page) {
            return false;
        }
        currentPage = page;
        this.updateSelection();
        return true;
    }

    @Override
    public int fabric_getPage(CreativeModeTab itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return currentPage;
        }
        FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl)itemGroup;
        return fabricItemGroup.fabric_getPage();
    }

    @Override
    public boolean fabric_hasAdditionalPages() {
        return CreativeModeTabs.tabs().size() > (Objects.requireNonNull(CreativeModeTabs.CACHED_PARAMETERS).hasPermissions() ? 14 : 13);
    }

    @Override
    public int fabric_getPageCount() {
        return FabricCreativeGuiComponents.getPageCount();
    }

    @Unique
    private boolean isGroupVisible(CreativeModeTab itemGroup) {
        return itemGroup.shouldDisplay() && currentPage == this.fabric_getPage(itemGroup);
    }

    @Unique
    private void updateSelection() {
        if (!this.isGroupVisible(selectedTab)) {
            CreativeModeTabs.allTabs().stream().filter(this::isGroupVisible).min((a, b) -> Boolean.compare(a.isAlignedRight(), b.isAlignedRight())).ifPresent(this::selectTab);
        }
    }

    @Unique
    private boolean hasGroupForPage(int page) {
        return CreativeModeTabs.tabs().stream().anyMatch(itemGroup -> this.fabric_getPage((CreativeModeTab)itemGroup) == page);
    }

    static {
        currentPage = 0;
    }
}

