/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    private Vec3 position;
    @Shadow
    private float nextStep;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private EntityDimensions dimensions;
    @Unique
    private boolean inModFluid;

    @Shadow
    protected abstract void playStepSound(BlockPos var1, BlockState var2);

    @Shadow
    protected abstract float nextStep();

    @Inject(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="HEAD")})
    private void clear(TagKey<Fluid> tag, double speed, CallbackInfoReturnable<Boolean> cir) {
        this.inModFluid = false;
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")})
    private void checkFluid(TagKey<Fluid> tag, double speed, CallbackInfoReturnable<Boolean> cir, @Local FluidState state) {
        if (!this.inModFluid) {
            this.inModFluid = state.getType() instanceof FlowableFluid;
        }
    }

    @Inject(method={"doWaterSplashEffect()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")}, cancellable=true)
    private void cancelEffect(CallbackInfo ci) {
        if (this.inModFluid) {
            ci.cancel();
        }
    }

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return (this.level.isClientSide() ? ContraptionHandlerClient.loadedContraptions : ContraptionHandler.loadedContraptions).get((LevelAccessor)this.level).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((Entity)this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.create$getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.level.getEntitiesOfClass(AbstractContraptionEntity.class, ((Entity)this).getBoundingBox().inflate(1.0)));
        return contraptions;
    }

    @Unique
    private void create$forCollision(Vec3 worldPos, TriConsumer<Contraption, BlockState, BlockPos> action) {
        this.create$getIntersectingContraptions().forEach(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            BlockPos blockPos = BlockPos.containing((Position)localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                BlockState blockstate = info.state();
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(method={"applyMovementEmissionAndPlaySound(Lnet/minecraft/world/entity/Entity$MovementEmission;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", ordinal=0)})
    private void create$contraptionStepSounds(Entity.MovementEmission moveEffect, Vec3 movement, BlockPos landingPos, BlockState landingState, CallbackInfo ci) {
        Vec3 worldPos = this.position.add(0.0, -0.2, 0.0);
        MutableBoolean stepped = new MutableBoolean(false);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, state, pos) -> {
            this.playStepSound((BlockPos)pos, (BlockState)state);
            stepped.setTrue();
        }));
        if (stepped.booleanValue()) {
            this.nextStep = this.nextStep();
        }
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="TAIL")})
    private void create$onMove(MoverType type, Vec3 movement, CallbackInfo ci) {
        if (!this.level.isClientSide()) {
            return;
        }
        Entity self = (Entity)this;
        if (self.onGround()) {
            return;
        }
        if (self.isPassenger()) {
            return;
        }
        Vec3 worldPos = this.position.add(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            Vec3 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            BlockPos blockPos = BlockPos.containing((Position)localPos);
            Contraption contraption = cEntity.getContraption();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        self.setOnGround(true);
        AllSynchedDatas.CONTRAPTION_GROUNDED.set(self, true);
    }

    @Inject(method={"spawnSprintParticle()V"}, at={@At(value="TAIL")})
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        Entity self = (Entity)this;
        Vec3 worldPos = this.position.add(0.0, -0.2, 0.0);
        this.create$forCollision(worldPos, (TriConsumer<Contraption, BlockState, BlockPos>)((TriConsumer)(contraption, state, pos) -> {
            if (state.getRenderShape() != RenderShape.INVISIBLE) {
                Vec3 speed = self.getDeltaMovement();
                this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), self.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.dimensions.width(), self.getY() + 0.1, self.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.dimensions.height(), speed.x * -4.0, 1.5, speed.z * -4.0);
            }
        }));
    }

    @WrapOperation(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;canSimulateMovement()Z")})
    private boolean move(Entity instance, Operation<Boolean> original) {
        if (((Boolean)original.call(new Object[]{instance})).booleanValue()) {
            return true;
        }
        return this.level instanceof PonderLevel;
    }
}

