/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.equipment.armor.BacktankFeatureRenderer;
import com.zurrtum.create.client.content.equipment.armor.CardboardArmorHandlerClient;
import com.zurrtum.create.client.content.equipment.hats.HatFeatureRenderer;
import com.zurrtum.create.client.content.equipment.hats.HatState;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> {
    @Shadow
    @Final
    protected List<RenderLayer<S, M>> layers;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void addFeature(EntityRendererProvider.Context ctx, M model, float shadowRadius, CallbackInfo ci) {
        Object renderer;
        if (model instanceof HumanoidModel) {
            renderer = new BacktankFeatureRenderer((RenderLayerParent)this);
            this.layers.add((RenderLayer<S, M>)renderer);
        }
        if (!((renderer = (LivingEntityRenderer)this) instanceof ShulkerRenderer) && !(renderer instanceof ArmorStandRenderer)) {
            this.layers.add(new HatFeatureRenderer(renderer));
        }
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;F)V"}, at={@At(value="TAIL")})
    private void addHat(T entity, S renderState, float f, CallbackInfo ci) {
        if (this.layers.stream().noneMatch(feature -> feature instanceof HatFeatureRenderer)) {
            return;
        }
        HatState state = (HatState)renderState;
        PartialModel hat = null;
        if (entity.isPassenger()) {
            CarriageContraption cc;
            BlockPos seatOf;
            Contraption contraption;
            CarriageContraptionEntity cce;
            ItemStack stack = entity.getItemBySlot(EquipmentSlot.HEAD);
            Entity vehicle = entity.getVehicle();
            if (stack.isEmpty() && vehicle instanceof CarriageContraptionEntity && ((cce = (CarriageContraptionEntity)vehicle).hasSchedule() || entity instanceof Player) && (contraption = cce.getContraption()) instanceof CarriageContraption && (seatOf = (cc = (CarriageContraption)contraption).getSeatOf(entity.getUUID())) != null && cc.conductorSeats.get(seatOf) != null) {
                hat = AllPartialModels.TRAIN_HAT;
                state.create$updateHatInfo((Entity)entity);
            }
            if (hat == null && vehicle instanceof SeatEntity) {
                Level level = entity.level();
                BlockPos pos = entity.blockPosition();
                boolean find = false;
                block0: for (Direction d : Iterate.horizontalDirections) {
                    for (int y : Iterate.zeroAndOne) {
                        if (!(level.getBlockState(pos.relative(d).above(y)).getBlock() instanceof StockTickerBlock)) continue;
                        if (find) {
                            find = false;
                            break block0;
                        }
                        find = true;
                    }
                }
                if (find) {
                    hat = AllPartialModels.LOGISTICS_HAT;
                    state.create$updateHatInfo((Entity)entity);
                }
            }
        } else if (entity instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            if (entity.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && AllSynchedDatas.PARROT_TRAIN_HAT.get((Entity)parrot).booleanValue()) {
                hat = AllPartialModels.TRAIN_HAT;
                state.create$updateHatInfo((Entity)entity);
            }
        }
        state.create$setHat(hat);
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(S state, PoseStack matrixStack, SubmitNodeCollector queue, CameraRenderState cameraRenderState, CallbackInfo ci) {
        AvatarRenderer renderer;
        LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)this;
        if (livingEntityRenderer instanceof AvatarRenderer && CardboardArmorHandlerClient.playerRendersAsBoxWhenSneaking(renderer = (AvatarRenderer)livingEntityRenderer, (AvatarRenderState)state, matrixStack, queue)) {
            ci.cancel();
        }
    }
}

