/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.google.gson.Gson;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.AllModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModelEventHandler;
import com.zurrtum.create.client.model.NormalsModelElement;
import com.zurrtum.create.client.model.UnbakedModelParser;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelManager.class})
public class ModelManagerMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"lambda$loadBlockModels$6"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/model/BlockModel;fromStream(Ljava/io/Reader;)Lnet/minecraft/client/renderer/block/model/BlockModel;")}, cancellable=true)
    private static void deserialize(CallbackInfoReturnable<Pair<Identifier, BlockModel>> cir, @Local Identifier identifier, @Local Reader input) {
        if (identifier.getNamespace().equals("create")) {
            try {
                UnbakedModel model = (UnbakedModel)GsonHelper.fromJson((Gson)UnbakedModelParser.GSON, (Reader)input, UnbakedModel.class);
                if (model instanceof BlockModel) {
                    BlockModel jsonModel = (BlockModel)model;
                    SimpleUnbakedGeometry geometry = (SimpleUnbakedGeometry)jsonModel.geometry();
                    if (geometry != null) {
                        geometry.elements().forEach(NormalsModelElement::markFacingNormals);
                    }
                    cir.setReturnValue((Object)Pair.of((Object)identifier, (Object)jsonModel));
                } else {
                    UnbakedModelParser.cache(identifier, model);
                    cir.setReturnValue(null);
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @WrapOperation(method={"lambda$loadBlockModels$7"}, at={@At(value="INVOKE", target="Ljava/util/List;stream()Ljava/util/stream/Stream;")})
    private static Stream<Pair<Identifier, UnbakedModel>> replace(List<Pair<Identifier, UnbakedModel>> instance, Operation<Stream<Pair<Identifier, UnbakedModel>>> original) {
        return Stream.concat((Stream)original.call(new Object[]{instance}), UnbakedModelParser.getCaches());
    }

    @Inject(method={"discoverModelDependencies"}, at={@At(value="NEW", target="(Lnet/minecraft/client/resources/model/ResolvedModel;Ljava/util/Map;)Lnet/minecraft/client/resources/model/ModelManager$ResolvedModels;")})
    private static void collect(Map<Identifier, UnbakedModel> modelMap, BlockStateModelLoader.LoadedModels stateDefinition, ClientItemInfoLoader.LoadedClientInfos result, CallbackInfoReturnable<ModelManager.ResolvedModels> cir, @Local ModelDiscovery collector) {
        Map models = stateDefinition.models();
        AllModels.ALL.forEach((state, resolver) -> {
            BlockStateModel.UnbakedRoot unbaked = (BlockStateModel.UnbakedRoot)resolver.apply(state, (BlockStateModel.UnbakedRoot)models.get(state));
            unbaked.resolveDependencies(arg_0 -> ((ModelDiscovery)collector).getOrCreateModel(arg_0));
            models.put(state, unbaked);
        });
        PartialModelEventHandler.getRegisterAdditional().keySet().forEach(arg_0 -> ((ModelDiscovery)collector).getOrCreateModel(arg_0));
    }
}

