/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.model.TransformationHelper;
import com.zurrtum.create.client.model.obj.ObjLoader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.GsonHelper;

public class UnbakedModelParser {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(UnbakedModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockModel.class, (Object)new BlockModel.Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).create();
    private static final Map<Identifier, UnbakedModel> CACHE = Maps.newConcurrentMap();

    public static void cache(Identifier id, UnbakedModel model) {
        CACHE.put(id, model);
    }

    public static Stream<Pair<Identifier, UnbakedModel>> getCaches() {
        return CACHE.entrySet().stream().map(entry -> Pair.of((Object)((Identifier)entry.getKey()), (Object)((UnbakedModel)entry.getValue())));
    }

    public static final class Deserializer
    implements JsonDeserializer<UnbakedModel> {
        public UnbakedModel deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("loader")) {
                String loader = GsonHelper.getAsString((JsonObject)jsonObject, (String)"loader");
                if (loader.equals("neoforge:obj")) {
                    return ObjLoader.INSTANCE.read(jsonObject, jsonDeserializationContext);
                }
                Create.LOGGER.warn("Unsupported loader: " + loader);
            }
            return (UnbakedModel)jsonDeserializationContext.deserialize((JsonElement)jsonObject, BlockModel.class);
        }
    }
}

