/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.api.level;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderWorldParticles;
import com.zurrtum.create.client.ponder.foundation.level.PonderChunk;
import com.zurrtum.create.ponder.api.VirtualBlockEntity;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PonderLevel
extends SchematicLevel {
    @Nullable
    public PonderScene scene;
    protected Map<BlockPos, BlockState> originalBlocks = new HashMap<BlockPos, BlockState>();
    protected Map<BlockPos, CompoundTag> originalBlockEntities = new HashMap<BlockPos, CompoundTag>();
    protected Map<BlockPos, Integer> blockBreakingProgressions = new HashMap<BlockPos, Integer>();
    protected List<Entity> originalEntities = new ArrayList<Entity>();
    @Nullable
    private Long2ObjectMap<PonderChunk> chunks;
    protected PonderWorldParticles particles = new PonderWorldParticles(this);
    int overrideLight;
    @Nullable
    Selection mask;
    boolean currentlyTickingEntities;

    public PonderLevel(BlockPos anchor, Level original) {
        super(anchor, original);
        this.renderMode = true;
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalBlockEntities.clear();
        this.originalBlocks.putAll(this.blocks);
        RegistryAccess registryManager = this.registryAccess();
        this.blockEntities.forEach((k, v) -> this.originalBlockEntities.put((BlockPos)k, v.saveWithFullMetadata((HolderLookup.Provider)registryManager)));
        this.entities.forEach(e -> {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(e.problemPath(), Ponder.LOGGER);){
                TagValueOutput writeView = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)registryManager);
                e.save((ValueOutput)writeView);
                ValueInput readView = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registryManager, (CompoundTag)writeView.buildResult());
                EntityType.create((ValueInput)readView, (Level)this, (EntitySpawnReason)EntitySpawnReason.LOAD).ifPresent(this.originalEntities::add);
            }
        });
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.blockEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedBlockEntities.clear();
        this.blocks.putAll(this.originalBlocks);
        RegistryAccess registryManager = this.registryAccess();
        this.originalBlockEntities.forEach((k, v) -> {
            BlockEntity blockEntity = BlockEntity.loadStatic((BlockPos)k, (BlockState)this.originalBlocks.get(k), (CompoundTag)v, (HolderLookup.Provider)registryManager);
            this.onBEAdded(blockEntity, blockEntity.getBlockPos());
            this.blockEntities.put(k, blockEntity);
            this.renderedBlockEntities.add(blockEntity);
        });
        this.originalEntities.forEach(e -> {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(e.problemPath(), Ponder.LOGGER);){
                TagValueOutput writeView = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)registryManager);
                e.save((ValueOutput)writeView);
                ValueInput readView = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registryManager, (CompoundTag)writeView.buildResult());
                EntityType.create((ValueInput)readView, (Level)this, (EntitySpawnReason)EntitySpawnReason.LOAD).ifPresent(this.entities::add);
            }
        });
        this.particles.clearEffects();
        PonderIndex.forEachPlugin(plugin -> plugin.onPonderLevelRestore(this));
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            BlockEntity blockEntity;
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalBlockEntities.containsKey(p) && (blockEntity = BlockEntity.loadStatic((BlockPos)p, (BlockState)this.originalBlocks.get(p), (CompoundTag)this.originalBlockEntities.get(p), (HolderLookup.Provider)this.registryAccess())) != null) {
                this.onBEAdded(blockEntity, blockEntity.getBlockPos());
                this.blockEntities.put(p, blockEntity);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int getBrightness(LightLayer p_226658_1_, BlockPos p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(@Nullable Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public BlockState getBlockState(BlockPos globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.subtract((Vec3i)this.anchor))) {
            return Blocks.AIR.defaultBlockState();
        }
        if (this.currentlyTickingEntities && globalPos.getY() < 0) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.getBlockState(globalPos);
    }

    public BlockGetter getChunkForCollisions(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(PoseStack ms, SubmitNodeCollector queue, Camera ari, CameraRenderState cameraRenderState, float pt) {
        Vec3 Vector3d2 = ari.position();
        double d0 = Vector3d2.x();
        double d1 = Vector3d2.y();
        double d2 = Vector3d2.z();
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
        for (Entity entity : this.entities) {
            if (entity.tickCount == 0) {
                entity.xOld = entity.getX();
                entity.yOld = entity.getY();
                entity.zOld = entity.getZ();
            }
            this.renderEntity(renderManager, entity, cameraRenderState, d0, d1, d2, pt, ms, queue);
        }
    }

    private void renderEntity(EntityRenderDispatcher renderManager, Entity entity, CameraRenderState cameraRenderState, double x, double y, double z, float pt, PoseStack ms, SubmitNodeCollector queue) {
        EntityRenderState state = renderManager.extractEntity(entity, pt);
        renderManager.submit(state, cameraRenderState, state.x - x, state.y - y, state.z - z, ms, queue);
    }

    public void renderParticles(PoseStack ms, SubmitNodeStorage queue, Camera ari, CameraRenderState cameraRenderState, float pt) {
        this.particles.renderParticles(ms, queue, ari, cameraRenderState, pt);
    }

    public void tick() {
        this.currentlyTickingEntities = true;
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ++entity.tickCount;
            entity.xOld = entity.getX();
            entity.yOld = entity.getY();
            entity.zOld = entity.getZ();
            entity.tick();
            if (entity.getY() <= -0.5) {
                entity.discard();
            }
            if (entity.isAlive()) continue;
            iterator.remove();
        }
        this.currentlyTickingEntities = false;
    }

    public void addParticle(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.particles.addParticle(data, x, y, z, mx, my, mz);
    }

    public void addAlwaysVisibleParticle(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(data, x, y, z, mx, my, mz);
    }

    public void addParticle(@Nullable Particle p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    protected void onBEAdded(BlockEntity blockEntity, BlockPos pos) {
        super.onBEadded(blockEntity, pos);
        if (!(blockEntity instanceof VirtualBlockEntity)) {
            return;
        }
        VirtualBlockEntity virtualBlockEntity = (VirtualBlockEntity)blockEntity;
        virtualBlockEntity.markVirtual();
    }

    public void setBlockBreakingProgress(BlockPos pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<BlockPos, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.getShape((BlockGetter)this, pos);
        if (voxelshape.isEmpty()) {
            return;
        }
        AABB bb = voxelshape.bounds();
        double d1 = Math.min(1.0, bb.maxX - bb.minX);
        double d2 = Math.min(1.0, bb.maxY - bb.minY);
        double d3 = Math.min(1.0, bb.maxZ - bb.minZ);
        int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
        int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
        int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.minX;
                    double d8 = d5 * d2 + bb.minY;
                    double d9 = d6 * d3 + bb.minZ;
                    this.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected BlockState processBlockStateForPrinting(BlockState state) {
        return state;
    }

    public boolean hasChunkAt(BlockPos pos) {
        return true;
    }

    public boolean hasChunkAt(int x, int y) {
        return true;
    }

    public boolean isLoaded(BlockPos pos) {
        return true;
    }

    public boolean hasNearbyAlivePlayer(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }

    public BlockHitResult clip(ClipContext context) {
        return (BlockHitResult)BlockGetter.traverseBlocks((Vec3)context.getFrom(), (Vec3)context.getTo(), (Object)context, (innerContext, pos) -> {
            BlockState blockState = this.getBlockState((BlockPos)pos);
            FluidState fluidState = blockState.getFluidState();
            Vec3 vec3d = innerContext.getFrom();
            Vec3 vec3d2 = innerContext.getTo();
            VoxelShape voxelShape = innerContext.getBlockShape(blockState, (BlockGetter)this, pos);
            BlockHitResult blockHitResult = this.clipWithInteractionOverride(vec3d, vec3d2, (BlockPos)pos, voxelShape, blockState);
            VoxelShape voxelShape2 = innerContext.getFluidShape(fluidState, (BlockGetter)this, pos);
            BlockHitResult blockHitResult2 = voxelShape2.clip(vec3d, vec3d2, pos);
            double d = blockHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult.getLocation());
            double e = blockHitResult2 == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult2.getLocation());
            return d <= e ? blockHitResult : blockHitResult2;
        }, innerContext -> {
            Vec3 vec3d = innerContext.getFrom().subtract(innerContext.getTo());
            return BlockHitResult.miss((Vec3)innerContext.getTo(), (Direction)Direction.getApproximateNearest((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)BlockPos.containing((Position)innerContext.getTo()));
        });
    }

    public LevelChunk getChunk(int x, int z) {
        if (this.chunks == null) {
            this.chunks = new Long2ObjectOpenHashMap();
        }
        return (LevelChunk)this.chunks.computeIfAbsent(ChunkPos.asLong((int)x, (int)z), packedPos -> new PonderChunk(this, ChunkPos.getX((long)packedPos), ChunkPos.getZ((long)packedPos)));
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus leastStatus, boolean create) {
        return this.getChunk(x, z);
    }
}

