/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.api.registration;

import com.zurrtum.create.client.ponder.api.scene.PonderStoryBoard;
import java.util.List;
import net.minecraft.resources.Identifier;

public interface StoryBoardEntry {
    public PonderStoryBoard getBoard();

    public String getNamespace();

    public Identifier getSchematicLocation();

    public Identifier getComponent();

    public List<Identifier> getTags();

    public List<SceneOrderingEntry> getOrderingEntries();

    default public StoryBoardEntry orderBefore(String otherSceneId) {
        return this.orderBefore(this.getNamespace(), otherSceneId);
    }

    public StoryBoardEntry orderBefore(String var1, String var2);

    default public StoryBoardEntry orderAfter(String otherSceneId) {
        return this.orderAfter(this.getNamespace(), otherSceneId);
    }

    public StoryBoardEntry orderAfter(String var1, String var2);

    public StoryBoardEntry highlightTag(Identifier var1);

    public StoryBoardEntry highlightTags(Identifier ... var1);

    public StoryBoardEntry highlightAllTags();

    public record SceneOrderingEntry(SceneOrderingType type, Identifier sceneId) {
        public static SceneOrderingEntry after(String namespace, String sceneId) {
            return new SceneOrderingEntry(SceneOrderingType.AFTER, Identifier.fromNamespaceAndPath((String)namespace, (String)sceneId));
        }

        public static SceneOrderingEntry before(String namespace, String sceneId) {
            return new SceneOrderingEntry(SceneOrderingType.BEFORE, Identifier.fromNamespaceAndPath((String)namespace, (String)sceneId));
        }
    }

    public static enum SceneOrderingType {
        BEFORE,
        AFTER;

    }
}

