/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PonderTag
implements ScreenElement {
    private final Identifier id;
    @Nullable
    private final Identifier textureIconLocation;
    private final ItemStack mainItem;
    private final GuiGameElement.GuiItemRenderBuilder itemIcon;

    public PonderTag(Identifier id, @Nullable Identifier textureIconLocation, ItemStack itemIcon, ItemStack mainItem) {
        this.id = id;
        this.textureIconLocation = textureIconLocation;
        this.mainItem = mainItem;
        this.itemIcon = textureIconLocation == null && !itemIcon.isEmpty() ? (GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(itemIcon).scale(1.25f).at(-2.0f, -2.0f) : null;
    }

    public Identifier getId() {
        return this.id;
    }

    public ItemStack getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderIndex.getLangAccess().getTagName(this.id);
    }

    public String getDescription() {
        return PonderIndex.getLangAccess().getTagDescription(this.id);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        if (this.textureIconLocation != null) {
            poseStack.scale(0.25f, 0.25f);
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.textureIconLocation, 0, 0, 0.0f, 0.0f, 0, 64, 64, 64, 64);
        } else if (this.itemIcon != null) {
            this.itemIcon.render(graphics);
        }
        poseStack.popMatrix();
    }

    public void clear() {
        if (this.itemIcon != null) {
            this.itemIcon.clear();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PonderTag)) {
            return false;
        }
        PonderTag otherTag = (PonderTag)other;
        return this.getId().equals((Object)otherTag.getId());
    }

    public static final class Highlight {
        public static final Identifier ALL = Ponder.asResource("_all");
    }
}

