/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.catnip.outliner.Outline;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionImpl {
    public static Selection of(BoundingBox bb) {
        return new Simple(bb);
    }

    private static class Simple
    implements Selection {
        private final BoundingBox bb;
        private final AABB aabb;
        private final Iterable<BlockPos> iterable;

        public Simple(BoundingBox bb) {
            this.bb = bb;
            this.aabb = new AABB((double)bb.minX(), (double)bb.minY(), (double)bb.minZ(), (double)(bb.maxX() + 1), (double)(bb.maxY() + 1), (double)(bb.maxZ() + 1));
            this.iterable = BlockPos.betweenClosed((int)Math.min(bb.minX(), bb.maxX()), (int)Math.min(bb.minY(), bb.maxY()), (int)Math.min(bb.minZ(), bb.maxZ()), (int)Math.max(bb.minX(), bb.maxX()), (int)Math.max(bb.minY(), bb.maxY()), (int)Math.max(bb.minZ(), bb.maxZ()));
        }

        @Override
        public boolean test(BlockPos t) {
            return this.bb.isInside((Vec3i)t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public Vec3 getCenter() {
            return this.aabb.getCenter();
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, this.aabb);
        }

        @Override
        public Selection copy() {
            return new Simple(new BoundingBox(this.bb.minX(), this.bb.minY(), this.bb.minZ(), this.bb.maxX(), this.bb.maxY(), this.bb.maxZ()));
        }

        @Override
        @NotNull
        public Iterator<BlockPos> iterator() {
            return this.iterable.iterator();
        }
    }

    private static class Compound
    implements Selection {
        private final Set<BlockPos> posSet;
        @Nullable
        private Vec3 center;

        public Compound(Simple initial) {
            this.posSet = new HashSet<BlockPos>();
            this.add(initial);
        }

        private Compound(Set<BlockPos> template) {
            this.posSet = new HashSet<BlockPos>(template);
        }

        @Override
        public boolean test(BlockPos t) {
            return this.posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> this.posSet.add(p.immutable()));
            this.center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> this.posSet.remove(p.immutable()));
            this.center = null;
            return this;
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, this.posSet);
        }

        @Override
        public Vec3 getCenter() {
            return this.center == null ? (this.center = this.evalCenter()) : this.center;
        }

        private Vec3 evalCenter() {
            Vec3 center = Vec3.ZERO;
            if (this.posSet.isEmpty()) {
                return center;
            }
            for (BlockPos blockPos : this.posSet) {
                center = center.add(Vec3.atLowerCornerOf((Vec3i)blockPos));
            }
            center = center.scale((double)(1.0f / (float)this.posSet.size()));
            return center.add(new Vec3(0.5, 0.5, 0.5));
        }

        @Override
        public Selection copy() {
            return new Compound(this.posSet);
        }

        @Override
        @NotNull
        public Iterator<BlockPos> iterator() {
            return this.posSet.iterator();
        }
    }
}

