/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.element.PonderElementBase;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class AnimatedSceneElementBase
extends PonderElementBase
implements AnimatedSceneElement {
    protected Vec3 fadeVec;
    protected LerpedFloat fade = LerpedFloat.linear().startWithValue(0.0);

    @Override
    public void forceApplyFade(float fade) {
        this.fade.startWithValue(fade);
    }

    @Override
    public void setFade(float fade) {
        this.fade.setValue(fade);
    }

    @Override
    public void setFadeVec(Vec3 fadeVec) {
        this.fadeVec = fadeVec;
    }

    @Override
    public final void renderFirst(BlockEntityRenderDispatcher blockEntityRenderDispatcher, BlockRenderDispatcher blockRenderManager, PonderLevel world, MultiBufferSource buffer, SubmitNodeCollector queue, Camera camera, CameraRenderState cameraRenderState, PoseStack poseStack, float pt) {
        poseStack.pushPose();
        float currentFade = this.applyFade(poseStack, pt);
        this.renderFirst(blockEntityRenderDispatcher, blockRenderManager, world, buffer, queue, camera, cameraRenderState, poseStack, currentFade, pt);
        poseStack.popPose();
    }

    @Override
    public final void renderLayer(PonderLevel world, MultiBufferSource buffer, ChunkSectionLayer type, PoseStack poseStack, float pt) {
        poseStack.pushPose();
        float currentFade = this.applyFade(poseStack, pt);
        this.renderLayer(world, buffer, type, poseStack, currentFade, pt);
        poseStack.popPose();
    }

    @Override
    public final void renderLast(EntityRenderDispatcher entityRenderManager, ItemModelResolver itemModelManager, PonderLevel world, MultiBufferSource buffer, SubmitNodeCollector queue, Camera camera, CameraRenderState cameraRenderState, PoseStack poseStack, float pt) {
        poseStack.pushPose();
        float currentFade = this.applyFade(poseStack, pt);
        this.renderLast(entityRenderManager, itemModelManager, world, buffer, queue, camera, cameraRenderState, poseStack, currentFade, pt);
        poseStack.popPose();
    }

    protected float applyFade(PoseStack ms, float pt) {
        float currentFade = this.fade.getValue(pt);
        if (this.fadeVec != null) {
            Vec3 scaled = this.fadeVec.scale((double)(-1.0f + currentFade));
            ms.translate(scaled.x, scaled.y, scaled.z);
        }
        return currentFade;
    }

    protected void renderLayer(PonderLevel world, MultiBufferSource buffer, ChunkSectionLayer type, PoseStack ms, float fade, float pt) {
    }

    protected void renderFirst(BlockEntityRenderDispatcher blockEntityRenderDispatcher, BlockRenderDispatcher blockRenderManager, PonderLevel world, MultiBufferSource buffer, SubmitNodeCollector queue, Camera camera, CameraRenderState cameraRenderState, PoseStack ms, float fade, float pt) {
    }

    protected void renderLast(EntityRenderDispatcher entityRenderManager, ItemModelResolver itemModelManager, PonderLevel world, MultiBufferSource buffer, SubmitNodeCollector queue, Camera camera, CameraRenderState cameraRenderState, PoseStack ms, float fade, float pt) {
    }

    protected int lightCoordsFromFade(float fade) {
        int light = 0xF000F0;
        if (fade != 1.0f) {
            light = Mth.lerpInt((float)fade, (int)5, (int)15);
            light = LightTexture.pack((int)light, (int)light);
        }
        return light;
    }
}

