/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.TextElementBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class TextWindowElement
extends AnimatedOverlayElementBase {
    public static final Couple<Color> COLOR_WINDOW_BORDER = Couple.create(new Color(1618632704, true), new Color(544890880, true)).map(Color::setImmutable);
    Supplier<String> textGetter = () -> "(?) No text was provided";
    @Nullable
    String bakedText;
    int y;
    @Nullable
    Vec3 vec;
    boolean nearScene = false;
    PonderPalette palette = PonderPalette.WHITE;

    public TextElementBuilder builder(PonderScene scene) {
        return new Builder(scene);
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, GuiGraphics graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        Vec2 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new Vec2((float)screen.width / 2.0f, (float)(screen.height - 200) / 2.0f + (float)this.y - 8.0f);
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.y) : sceneToScreen.y;
        float yDiff = ((float)screen.height / 2.0f - sceneToScreen.y - 10.0f) / 100.0f;
        float targetX = (float)screen.width * Mth.lerp((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.x + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.width - targetX, 180.0f);
        Font fontRenderer = screen.getFontRenderer();
        List lines = fontRenderer.getSplitter().splitLines(this.bakedText, textWidth, Style.EMPTY);
        int boxWidth = 0;
        for (FormattedText line : lines) {
            boxWidth = Math.max(boxWidth, fontRenderer.width(line));
        }
        int boxHeight = fontRenderer.wordWrapHeight((FormattedText)Component.literal((String)this.bakedText), boxWidth);
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(0.0f, pY);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(COLOR_WINDOW_BORDER)).at(targetX - 10.0f, 3.0f, -101.0f).withBounds(boxWidth, boxHeight - 1).render(graphics);
        Color brighter = this.palette.getColorObject().mixWith(new Color(-35), 0.5f).setImmutable();
        Color c1 = new Color(-11974327);
        Color c2 = new Color(-13027015);
        if (this.vec != null) {
            poseStack.pushMatrix();
            poseStack.translate(sceneToScreen.x, 0.0f);
            double lineTarget = (targetX - sceneToScreen.x) * fade;
            poseStack.scale((float)lineTarget, 1.0f);
            graphics.fillGradient(0, 0, 1, 1, brighter.getRGB(), brighter.getRGB());
            graphics.fillGradient(0, 1, 1, 2, c1.getRGB(), c2.getRGB());
            poseStack.popMatrix();
        }
        for (int i = 0; i < lines.size(); ++i) {
            graphics.drawString(fontRenderer, ((FormattedText)lines.get(i)).getString(), (int)(targetX - 10.0f), 3 + 9 * i, brighter.scaleAlphaForText(fade).getRGB(), false);
        }
        poseStack.popMatrix();
    }

    public PonderPalette getPalette() {
        return this.palette;
    }

    private class Builder
    implements TextElementBuilder {
        private final PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        @Override
        public Builder colored(PonderPalette color) {
            TextWindowElement.this.palette = color;
            return this;
        }

        @Override
        public Builder pointAt(Vec3 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        @Override
        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        @Override
        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        @Override
        public TextElementBuilder text(String defaultText, Object ... params) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText, params);
            return this;
        }

        @Override
        public Builder sharedText(Identifier key) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key);
            return this;
        }

        @Override
        public TextElementBuilder sharedText(Identifier key, Object ... params) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key, params);
            return this;
        }

        @Override
        public Builder sharedText(String key) {
            return this.sharedText(Identifier.fromNamespaceAndPath((String)this.scene.getNamespace(), (String)key));
        }

        @Override
        public TextElementBuilder sharedText(String key, Object ... params) {
            return this.sharedText(Identifier.fromNamespaceAndPath((String)this.scene.getNamespace(), (String)key), params);
        }

        @Override
        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        @Override
        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

