/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedOverlayElementBase;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedSceneElementBase;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class HideAllInstruction
extends TickingInstruction {
    private final Direction fadeOutTo;

    public HideAllInstruction(int fadeOutTicks, Direction fadeOutTo) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.getElements().forEach(element -> {
            if (element instanceof AnimatedSceneElementBase) {
                AnimatedSceneElementBase animatedSceneElement = (AnimatedSceneElementBase)element;
                animatedSceneElement.setFade(1.0f);
                animatedSceneElement.setFadeVec(this.fadeOutTo == null ? null : Vec3.atLowerCornerOf((Vec3i)this.fadeOutTo.getUnitVec3i()).scale(0.5));
            } else if (element instanceof AnimatedOverlayElementBase) {
                AnimatedOverlayElementBase animatedSceneElement = (AnimatedOverlayElementBase)element;
                animatedSceneElement.setFade(1.0f);
            } else {
                element.setVisible(false);
            }
        });
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        scene.forEach(AnimatedSceneElementBase.class, ase -> {
            ase.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                ase.setFade(0.0f);
            }
        });
        scene.forEach(AnimatedOverlayElementBase.class, aoe -> {
            aoe.setFade(fade * fade);
            if (this.remainingTicks == 0) {
                aoe.setFade(0.0f);
            }
        });
    }
}

