/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.client.ponder.api.registration.MultiSceneBuilder;
import com.zurrtum.create.client.ponder.api.registration.PonderSceneRegistrationHelper;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.PonderStoryBoard;
import java.util.function.Consumer;
import net.minecraft.resources.Identifier;

public class GenericMultiSceneBuilder<T>
implements MultiSceneBuilder {
    protected Iterable<? extends T> components;
    protected PonderSceneRegistrationHelper<T> helper;

    protected GenericMultiSceneBuilder(PonderSceneRegistrationHelper<T> helper, Iterable<? extends T> components) {
        this.helper = helper;
        this.components = components;
    }

    @Override
    public MultiSceneBuilder addStoryBoard(Identifier schematicLocation, PonderStoryBoard storyBoard) {
        return this.addStoryBoard(schematicLocation, storyBoard, (StoryBoardEntry $) -> {});
    }

    @Override
    public MultiSceneBuilder addStoryBoard(Identifier schematicLocation, PonderStoryBoard storyBoard, Identifier ... tags) {
        return this.addStoryBoard(schematicLocation, storyBoard, (StoryBoardEntry sb) -> sb.highlightTags(tags));
    }

    @Override
    public MultiSceneBuilder addStoryBoard(Identifier schematicLocation, PonderStoryBoard storyBoard, Consumer<StoryBoardEntry> extras) {
        this.components.forEach(c -> extras.accept(this.helper.addStoryBoard(c, schematicLocation, storyBoard, new Identifier[0])));
        return this;
    }

    @Override
    public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoard storyBoard) {
        return this.addStoryBoard(this.helper.asLocation(schematicPath), storyBoard);
    }

    @Override
    public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoard storyBoard, Identifier ... tags) {
        return this.addStoryBoard(this.helper.asLocation(schematicPath), storyBoard, tags);
    }

    @Override
    public MultiSceneBuilder addStoryBoard(String schematicPath, PonderStoryBoard storyBoard, Consumer<StoryBoardEntry> extras) {
        return this.addStoryBoard(this.helper.asLocation(schematicPath), storyBoard, extras);
    }
}

