/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.registration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.registration.TagRegistryAccess;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.registration.PonderLocalization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Items;

public class PonderTagRegistry
implements TagRegistryAccess {
    private final PonderLocalization localization;
    private final Multimap<Identifier, Identifier> componentTagMap;
    private final Map<Identifier, PonderTag> registeredTags;
    private final List<PonderTag> listedTags;
    private final PonderTag MISSING = new PonderTag(Ponder.asResource("not_registered"), null, Items.BARRIER.getDefaultInstance(), Items.BARRIER.getDefaultInstance());
    private boolean allowRegistration = true;

    public PonderTagRegistry(PonderLocalization localization) {
        this.localization = localization;
        this.componentTagMap = LinkedHashMultimap.create();
        this.registeredTags = new HashMap<Identifier, PonderTag>();
        this.listedTags = new ArrayList<PonderTag>();
    }

    public void clearRegistry() {
        this.componentTagMap.clear();
        this.listedTags.clear();
        this.allowRegistration = true;
    }

    public void registerTag(PonderTag tag) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.registeredTags.put(tag.getId(), tag);
    }

    public void listTag(PonderTag tag) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.listedTags.add(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTagToComponent(Identifier tag, Identifier item) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        Multimap<Identifier, Identifier> multimap = this.componentTagMap;
        synchronized (multimap) {
            this.componentTagMap.put((Object)item, (Object)tag);
        }
    }

    @Override
    public PonderTag getRegisteredTag(Identifier tagLocation) {
        return this.registeredTags.getOrDefault(tagLocation, this.MISSING);
    }

    @Override
    public List<PonderTag> getListedTags() {
        return this.listedTags;
    }

    @Override
    public Set<PonderTag> getTags(Identifier item) {
        return this.componentTagMap.get((Object)item).stream().map(this::getRegisteredTag).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Identifier> getItems(Identifier tag) {
        return (Set)this.componentTagMap.entries().stream().filter(e -> ((Identifier)e.getValue()).equals((Object)tag)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<Identifier> getItems(PonderTag tag) {
        return this.getItems(tag.getId());
    }
}

