/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.DefaultSuperRenderTypeBuffer;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SceneRenderer
extends PictureInPictureRenderer<SceneRenderState> {
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.4f, -1.0f, 0.7f).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.4f, -0.5f, 0.7f).normalize();
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public SceneRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(SceneRenderState renderState, GuiRenderState state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = renderState.width() * windowScaleFactor;
        int height = renderState.height() * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(renderState.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(renderState.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.scale((float)windowScaleFactor, (float)windowScaleFactor, 1.0f);
        Minecraft mc = Minecraft.getInstance();
        GameRenderer gameRenderer = mc.gameRenderer;
        Lighting lighting = gameRenderer.getLighting();
        FeatureRenderDispatcher renderDispatcher = gameRenderer.getFeatureRenderDispatcher();
        lighting.updateBuffer(Lighting.Entry.LEVEL, DIFFUSE_LIGHT_0, DIFFUSE_LIGHT_1);
        lighting.setupFor(Lighting.Entry.LEVEL);
        SubmitNodeStorage queue = renderDispatcher.getSubmitNodeStorage();
        this.renderScene(mc, renderState, this.matrices, queue);
        renderDispatcher.renderAllFeatures();
        this.bufferSource.endBatch();
        lighting.updateLevel(mc.level.dimensionType().cardinalLightType());
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), renderState.pose(), renderState.x0(), renderState.y0(), renderState.x1(), renderState.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    private void renderScene(Minecraft mc, SceneRenderState state, PoseStack poseStack, SubmitNodeStorage queue) {
        float partialTicks = state.partialTicks();
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        PonderScene scene = state.scene();
        poseStack.translate(0.0f, 0.0f, -800.0f);
        PonderScene.SceneTransform transform = scene.getTransform();
        transform.updateScreenParams(state.width(), state.height(), state.slide());
        transform.apply(poseStack, partialTicks);
        transform.updateSceneRVE(partialTicks);
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            poseStack.pushPose();
            poseStack.translate((float)scene.getBasePlateOffsetX(), 0.0f, (float)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(poseStack);
            float alpha = flash = state.finishingFlash().getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                poseStack.translate((float)scene.getBasePlateSize(), 0.0f, 0.0f);
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, -9.765625E-4f);
                if (flash > 0.0f) {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    SceneRenderer.fillGradient((MultiBufferSource)this.bufferSource, this.matrices, 0, -1, -scene.getBasePlateSize(), 0, 0, new Color(13041609).getRGB(), new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    poseStack.popPose();
                }
                poseStack.translate(0.0f, 0.0f, 0.001953125f);
                SceneRenderer.fillGradient((MultiBufferSource)this.bufferSource, this.matrices, 0, 0, -scene.getBasePlateSize(), 4, 0, new Color(0x66000000).getRGB(), new Color(0).getRGB());
                poseStack.popPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            }
            poseStack.popPose();
        }
        this.bufferSource.endBatch();
        scene.renderScene(mc, buffer, queue, poseStack, partialTicks);
        buffer.draw();
    }

    public static void fillGradient(MultiBufferSource vertexConsumers, PoseStack matrices, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        VertexConsumer buffer = vertexConsumers.getBuffer(PonderRenderTypes.getGui());
        Matrix4f matrix4f = matrices.last().pose();
        buffer.addVertex((Matrix4fc)matrix4f, (float)x1, (float)y1, (float)z).setColor(colorFrom);
        buffer.addVertex((Matrix4fc)matrix4f, (float)x1, (float)y2, (float)z).setColor(colorTo);
        buffer.addVertex((Matrix4fc)matrix4f, (float)x2, (float)y2, (float)z).setColor(colorTo);
        buffer.addVertex((Matrix4fc)matrix4f, (float)x2, (float)y1, (float)z).setColor(colorFrom);
    }

    protected void renderToTexture(SceneRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Scene";
    }

    public Class<SceneRenderState> getRenderStateClass() {
        return SceneRenderState.class;
    }
}

