/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Quaternionfc;

public class TitleTextRenderer
extends PictureInPictureRenderer<TitleTextRenderState> {
    public TitleTextRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(TitleTextRenderState state, PoseStack matrices) {
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.translate(-90.0f, -20.0f, 0.0f);
        Font font = Minecraft.getInstance().font;
        float indexDiff = state.diff();
        float absoluteIndexDiff = Math.abs(indexDiff);
        float angle = indexDiff * -90.0f;
        matrices.translate(0.0f, 6.0f, 0.0f);
        matrices.pushPose();
        matrices.mulPose((Quaternionfc)Axis.XN.rotationDegrees(angle + Math.signum(indexDiff) * 90.0f));
        matrices.translate(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString((MultiBufferSource)this.bufferSource, matrices, font, state.otherTitle(), 0, 0, 180, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(absoluteIndexDiff).getRGB());
        matrices.popPose();
        matrices.mulPose((Quaternionfc)Axis.XN.rotationDegrees(angle));
        matrices.translate(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString((MultiBufferSource)this.bufferSource, matrices, font, state.title(), 0, 0, 180, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(1.0f - absoluteIndexDiff).getRGB());
    }

    protected String getTextureLabel() {
        return "Title Text";
    }

    public Class<TitleTextRenderState> getRenderStateClass() {
        return TitleTextRenderState.class;
    }
}

