/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.catnip.layout.LayoutHelper;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.foundation.PonderChapter;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.ui.AbstractPonderScreen;
import com.zurrtum.create.client.ponder.foundation.ui.PonderButton;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PonderTagScreen
extends AbstractPonderScreen {
    private final PonderTag tag;
    protected final List<ItemEntry> items = new ArrayList<ItemEntry>();
    private final double itemXmult = 0.5;
    @Nullable
    protected Rect2i itemArea;
    protected final List<PonderChapter> chapters = new ArrayList<PonderChapter>();
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    @Nullable
    protected Rect2i chapterArea;
    private final double mainYmult = 0.15;
    private ItemStack hoveredItem = ItemStack.EMPTY;

    public PonderTagScreen(Identifier tag) {
        this.tag = PonderIndex.getTagAccess().getRegisteredTag(tag);
    }

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
    }

    @Override
    protected void init() {
        super.init();
        this.items.clear();
        PonderIndex.getTagAccess().getItems(this.tag).stream().map(key -> new ItemEntry(RegisteredObjectsHelper.getItemOrBlock(key), (Identifier)key)).filter(entry -> entry.item != null).forEach(this.items::add);
        if (!this.tag.getMainItem().isEmpty()) {
            this.items.removeIf(entry -> entry.item == this.tag.getMainItem().getItem());
        }
        int rowCount = Mth.clamp((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.width * 0.5);
        int itemCenterY = this.getItemsY();
        for (ItemEntry entry2 : this.items) {
            Object b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new ItemStack(entry2.item));
            if (PonderIndex.getSceneAccess().doScenesExistForId(entry2.key)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new ItemStack(entry.item), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(entry2.key.getNamespace().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.addRenderableWidget((GuiEventListener)b);
            layout.next();
        }
        if (!this.tag.getMainItem().isEmpty()) {
            Identifier registryName = RegisteredObjectsHelper.getKeyOrThrow(this.tag.getMainItem().getItem());
            Object b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 48, itemCenterY - 10).showing(this.tag.getMainItem());
            if (PonderIndex.getSceneAccess().doScenesExistForId(registryName)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
                });
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(registryName.getNamespace().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)).animateColors(false);
            }
            this.addRenderableWidget((GuiEventListener)b);
        }
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(this.tag);
    }

    @Override
    public void tick() {
        super.tick();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.EMPTY;
        Window w = this.minecraft.getWindow();
        int mX = (int)(this.minecraft.mouseHandler.xpos() * (double)w.getGuiScaledWidth() / (double)w.getScreenWidth());
        int mY = (int)(this.minecraft.mouseHandler.ypos() * (double)w.getGuiScaledHeight() / (double)w.getScreenHeight());
        for (GuiEventListener child : this.children()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).isMouseOver(mX, mY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        this.renderItems(graphics, mouseX, mouseY, partialTicks);
        this.renderChapters(graphics, mouseX, mouseY, partialTicks);
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)(this.width / 2 - 120), (float)((double)this.height * 0.15 - 40.0));
        poseStack.pushMatrix();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(graphics, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(21.0f, 21.0f, 100.0f).withBounds(30, 30).render(graphics);
        graphics.drawString(this.font, (Component)Ponder.lang().translate("ui.pondering_tag", new Object[0]).component(), x, y - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
        poseStack.translate((float)(x += 0), (float)(y += 8));
        graphics.drawString(this.font, title, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate(23.0f, 23.0f);
        poseStack.scale(1.66f, 1.66f);
        this.tag.render(graphics, 0, 0);
        poseStack.popMatrix();
        poseStack.popMatrix();
        poseStack.pushMatrix();
        int w = (int)((double)this.width * 0.45);
        x = (this.width - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.getHeight(), 48);
        String desc = this.tag.getDescription();
        int h = this.font.wordWrapHeight((FormattedText)Component.literal((String)desc), w);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(x - 3, y - 3, 90.0f).withBounds(w + 6, h + 6).render(graphics);
        ClientFontHelper.drawSplitString(graphics, this.font, desc, x, y, w, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.popMatrix();
    }

    protected void renderItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.width * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Ponder.lang().translate("ui.associated", new Object[0]).string();
        int stringWidth = this.font.width(relatedTitle);
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)x, (float)y);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.getY() - 21, 100.0f).withBounds(stringWidth + 10, 10).render(graphics);
        graphics.drawCenteredString(this.font, relatedTitle, this.windowWidth / 2, this.itemArea.getY() - 20, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, this.itemArea.getHeight() + 10, this.itemArea.getWidth() / 2 + 75);
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, this.itemArea.getHeight() + 10, this.itemArea.getWidth() / 2 + 75);
        poseStack.popMatrix();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.height + 85.0);
    }

    protected void renderChapters(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.width * 0.5);
        int chapterY = (int)((double)this.height * 0.75);
        Matrix3x2fStack matrices = graphics.pose();
        matrices.pushMatrix();
        matrices.translate((float)chapterX, (float)chapterY);
        UIRenderHelper.streak(graphics, 0.0f, this.chapterArea.getX() - 10, this.chapterArea.getY() - 20, 20, 220);
        graphics.drawString(this.font, "More Topics to Ponder about", this.chapterArea.getX() - 5, this.chapterArea.getY() - 25, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
        matrices.popMatrix();
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.hoveredItem.isEmpty()) {
            graphics.setTooltipForNextFrame(this.font, this.hoveredItem, mouseX, mouseY);
        }
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    @Override
    public void removed() {
        super.removed();
        this.hoveredItem = ItemStack.EMPTY;
        for (Renderable drawable : this.renderables) {
            if (!(drawable instanceof ElementWidget)) continue;
            ElementWidget widget = (ElementWidget)drawable;
            widget.getRenderElement().clear();
        }
    }

    public record ItemEntry(@Nullable ItemLike item, Identifier key) {
    }
}

