/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin;

import com.zurrtum.create.client.vanillin.VanillinXplat;
import com.zurrtum.create.client.vanillin.VisualElements;
import com.zurrtum.create.client.vanillin.compose.ComposableEntityVisual;
import com.zurrtum.create.client.vanillin.compose.ConfiguredElement;
import com.zurrtum.create.client.vanillin.compose.ConfiguredElementImpl;
import com.zurrtum.create.client.vanillin.compose.VisualElement;
import com.zurrtum.create.client.vanillin.compose.VisualizationPredicate;
import com.zurrtum.create.client.vanillin.config.BlockEntityVisualizerBuilder;
import com.zurrtum.create.client.vanillin.config.Configurator;
import com.zurrtum.create.client.vanillin.config.EntityVisualizerBuilder;
import com.zurrtum.create.client.vanillin.elements.ShadowElement;
import com.zurrtum.create.client.vanillin.visuals.BellVisual;
import com.zurrtum.create.client.vanillin.visuals.BlockDisplayVisual;
import com.zurrtum.create.client.vanillin.visuals.ChestVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemDisplayVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemFrameVisual;
import com.zurrtum.create.client.vanillin.visuals.ItemVisual;
import com.zurrtum.create.client.vanillin.visuals.MinecartVisual;
import com.zurrtum.create.client.vanillin.visuals.ShulkerBoxVisual;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class VanillaVisuals {
    public static final Configurator CONFIGURATOR = new Configurator();
    public static final boolean STABLE = true;
    public static final boolean EXPERIMENTAL = VanillinXplat.INSTANCE.isDevelopmentEnvironment();

    public static void init() {
        VanillaVisuals.builder(BlockEntityType.CHEST).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.ENDER_CHEST).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.TRAPPED_CHEST).factory(ChestVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.BELL).factory(BellVisual::new).apply(true);
        VanillaVisuals.builder(BlockEntityType.SHULKER_BOX).factory(ShulkerBoxVisual::new).apply(true);
        VanillaVisuals.builder(EntityType.BLOCK_DISPLAY).factory(BlockDisplayVisual::new).apply(true);
        VanillaVisuals.composable(EntityType.ITEM_DISPLAY).with(VanillaVisuals.element(VisualElements.ITEM_DISPLAY).build()).shouldVisualize((ctx, e) -> ItemDisplayVisual.shouldVisualize(e)).build().skipVanillaRender(ItemDisplayVisual::shouldVisualize).apply(EXPERIMENTAL);
        VanillaVisuals.minecart(EntityType.CHEST_MINECART, ModelLayers.CHEST_MINECART).apply(true);
        VanillaVisuals.minecart(EntityType.COMMAND_BLOCK_MINECART, ModelLayers.COMMAND_BLOCK_MINECART).apply(true);
        VanillaVisuals.minecart(EntityType.FURNACE_MINECART, ModelLayers.FURNACE_MINECART).apply(true);
        VanillaVisuals.minecart(EntityType.HOPPER_MINECART, ModelLayers.HOPPER_MINECART).apply(true);
        VanillaVisuals.minecart(EntityType.MINECART, ModelLayers.MINECART).apply(true);
        VanillaVisuals.minecart(EntityType.SPAWNER_MINECART, ModelLayers.SPAWNER_MINECART).apply(true);
        VanillaVisuals.composable(EntityType.TNT_MINECART).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.TNT_MINECART).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender).apply(true);
        VanillaVisuals.itemFrame(EntityType.ITEM_FRAME).apply(EXPERIMENTAL);
        VanillaVisuals.itemFrame(EntityType.GLOW_ITEM_FRAME).apply(EXPERIMENTAL);
        VanillaVisuals.composable(EntityType.ITEM).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.15f, 0.75f)).build()).with(VanillaVisuals.element(VisualElements.ITEM_ENTITY).build()).shouldVisualize((ctx, entity) -> ItemVisual.isSupported(entity)).build().skipVanillaRender(ItemVisual::isSupported).apply(EXPERIMENTAL);
    }

    public static <T extends Entity> void commonElements(EntityBuilder<T> builder) {
        builder.with(VanillaVisuals.element(VisualElements.HITBOX).configure(false).build());
    }

    public static <T extends ItemFrame> EntityVisualizerBuilder<T> itemFrame(EntityType<T> type) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.ITEM_FRAME).build()).shouldVisualize((ctx, entity) -> ItemFrameVisual.shouldVisualize(entity)).build().skipVanillaRender(ItemFrameVisual::shouldVisualize);
    }

    public static <T extends AbstractMinecart> EntityVisualizerBuilder<T> minecart(EntityType<T> type, ModelLayerLocation variant) {
        return VanillaVisuals.composable(type).apply(VanillaVisuals::commonElements).with(VanillaVisuals.element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, 1.0f)).build()).with(VanillaVisuals.element(VisualElements.FIRE).build()).with(VanillaVisuals.element(VisualElements.MINECART).configure(variant).build()).build().skipVanillaRender(MinecartVisual::shouldSkipRender);
    }

    public static <T extends Entity> EntityBuilder<T> composable(EntityType<T> entityType) {
        return new EntityBuilder<T>(entityType);
    }

    public static <T, C> ConfiguredElementImpl.ConfiguredElementBuilder<T, C> element(VisualElement<T, C> element) {
        return new ConfiguredElementImpl.ConfiguredElementBuilder<T, C>(element);
    }

    public static <T extends BlockEntity> BlockEntityVisualizerBuilder<T> builder(BlockEntityType<T> type) {
        return new BlockEntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    public static <T extends Entity> EntityVisualizerBuilder<T> builder(EntityType<T> type) {
        return new EntityVisualizerBuilder<T>(CONFIGURATOR, type);
    }

    public static class EntityBuilder<T extends Entity> {
        private final List<ConfiguredElement<? super T>> elements = new ArrayList<ConfiguredElement<? super T>>();
        private final EntityType<T> entityType;
        @Nullable
        private VisualizationPredicate<T> predicate;

        public EntityBuilder(EntityType<T> entityType) {
            this.entityType = entityType;
        }

        public EntityBuilder<T> shouldVisualize(VisualizationPredicate<T> predicate) {
            this.predicate = predicate;
            return this;
        }

        public EntityBuilder<T> with(ConfiguredElement<? super T> element) {
            this.elements.add(element);
            return this;
        }

        public EntityBuilder<T> apply(Consumer<EntityBuilder<T>> mutate) {
            mutate.accept(this);
            return this;
        }

        public EntityVisualizerBuilder<T> build() {
            ConfiguredElement[] elementsArray = this.elements.toArray(new ConfiguredElement[0]);
            if (this.predicate == null) {
                this.predicate = VisualizationPredicate.alwaysTrue();
            }
            ComposableEntityVisual.Controller controller = new ComposableEntityVisual.Controller(elementsArray, this.predicate);
            return VanillaVisuals.builder(this.entityType).factory((ctx, entity, partialTick) -> new ComposableEntityVisual<Entity>(ctx, entity, partialTick, controller));
        }
    }
}

