/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin;

import com.zurrtum.create.catnip.config.Builder;
import com.zurrtum.create.catnip.config.ConfigBase;
import com.zurrtum.create.client.vanillin.Vanillin;
import com.zurrtum.create.client.vanillin.config.CClient;
import com.zurrtum.create.client.vanillin.config.Configurator;
import com.zurrtum.create.client.vanillin.config.ModOverrides;
import com.zurrtum.create.client.vanillin.config.VisualConfigValue;
import com.zurrtum.create.client.vanillin.config.VisualOverride;
import com.zurrtum.create.client.vanillin.config.VisualOverrideValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class VanillinConfig {
    public static final String VANILLIN_OVERRIDES = "vanillin:overrides";
    private static ModOverrides overrides;
    private static CClient client;

    public static ModOverrides modOverrides() {
        ArrayList<VisualOverride> blockEntities = new ArrayList<VisualOverride>();
        ArrayList<VisualOverride> entities = new ArrayList<VisualOverride>();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = container.getMetadata();
            String modid = meta.getId();
            if (!meta.containsCustomValue(VANILLIN_OVERRIDES)) continue;
            CustomValue overridesValue = meta.getCustomValue(VANILLIN_OVERRIDES);
            if (overridesValue.getType() != CustomValue.CvType.OBJECT) {
                Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override options with an invalid value, ignoring", (Object)modid);
                continue;
            }
            CustomValue.CvObject overrides = overridesValue.getAsObject();
            VanillinConfig.readSection(blockEntities, modid, overrides, "block_entities", "block entity");
            VanillinConfig.readSection(entities, modid, overrides, "entities", "entity");
        }
        return new ModOverrides(blockEntities, entities);
    }

    private static void readSection(List<VisualOverride> dst, String modid, CustomValue.CvObject overrides, String sectionName, String singular) {
        if (!overrides.containsKey(sectionName)) {
            return;
        }
        CustomValue section = overrides.get(sectionName);
        if (section.getType() != CustomValue.CvType.OBJECT) {
            Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} with an invalid value, ignoring", (Object)modid, (Object)sectionName);
            return;
        }
        for (Map.Entry entry : section.getAsObject()) {
            CustomValue value = (CustomValue)entry.getValue();
            String key = (String)entry.getKey();
            if (value.getType() != CustomValue.CvType.STRING) {
                Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} '{}' with an invalid value, ignoring", new Object[]{modid, singular, key});
                continue;
            }
            String valueString = value.getAsString();
            VisualOverrideValue parsed = VisualOverrideValue.parse(valueString);
            if (parsed == null) {
                Vanillin.CONFIG_LOGGER.warn("Mod '{}' attempted to override {} '{}' with an invalid value '{}', ignoring", new Object[]{modid, singular, key, valueString});
                continue;
            }
            dst.add(new VisualOverride(key, modid, parsed));
        }
    }

    public static CClient client() {
        return client;
    }

    public static void register() {
        client = Builder.create(CClient::new, "vanillin", "client", true);
        overrides = VanillinConfig.modOverrides();
    }

    public static void apply(Configurator configurator) {
        Map<String, ConfigBase.ConfigEnum<VisualConfigValue>> blockEntities = VanillinConfig.client.blockEntities;
        Map<String, List<VisualOverride>> blockEntityOverrides = overrides.blockEntities();
        for (Configurator.ConfiguredVisual configuredVisual : configurator.blockEntities.values()) {
            VanillinConfig.apply(configuredVisual, blockEntities, blockEntityOverrides);
        }
        Map<String, ConfigBase.ConfigEnum<VisualConfigValue>> entities = VanillinConfig.client.entities;
        Map<String, List<VisualOverride>> map = overrides.entities();
        for (Configurator.ConfiguredVisual configuredVisual : configurator.entities.values()) {
            VanillinConfig.apply(configuredVisual, entities, map);
        }
    }

    private static void apply(Configurator.ConfiguredVisual configured, Map<String, ConfigBase.ConfigEnum<VisualConfigValue>> config, Map<String, List<VisualOverride>> overrides) {
        String key = configured.configKey();
        VisualConfigValue enabled = (VisualConfigValue)((Object)config.get(key).get());
        configured.set(enabled, overrides.get(key));
    }
}

