/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.item;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedItemModelBufferer;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemChunkLayerSortedListBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshHelper;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.vanillin.Vanillin;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;

public class ItemModels {
    public static final TagKey<Item> NO_INSTANCING = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Vanillin.rl("no_instancing"));
    private static final Model EMPTY_MODEL = new SimpleModel(List.of());
    private static final RendererReloadCache<BakedModelKey, Model> MODEL_CACHE = new RendererReloadCache<BakedModelKey, Model>(key -> ItemModels.bakeModel(key.world(), key.stack(), key.displayContext()));
    private static final Map<ItemStack, Boolean> SUPPORT_CACHE = new Object2BooleanLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack itemStack) {
            return ItemStack.hashItemAndComponents((ItemStack)itemStack);
        }

        public boolean equals(ItemStack itemStack, ItemStack itemStack2) {
            return itemStack == itemStack2 || itemStack != null && itemStack2 != null && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)itemStack2);
        }
    });
    private static final ThreadLocal<ItemStackRenderState> STATE = ThreadLocal.withInitial(ItemStackRenderState::new);

    public static boolean isSupported(ItemStack stack, ItemDisplayContext context) {
        if (stack.is(NO_INSTANCING)) {
            return false;
        }
        Boolean cache = SUPPORT_CACHE.get(stack);
        if (cache != null) {
            return cache;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemStackRenderState state = STATE.get();
        mc.getItemModelResolver().updateForTopItem(state, stack, context, (Level)mc.level, null, 0);
        boolean support = !state.isAnimated();
        SUPPORT_CACHE.put(stack.copy(), support);
        return support;
    }

    public static ItemModel getModel(ItemStack stack) {
        return Minecraft.getInstance().getModelManager().getItemModel((Identifier)stack.get(DataComponents.ITEM_MODEL));
    }

    public static Model get(Level world, ItemStack itemStack, ItemDisplayContext displayContext) {
        if (itemStack.isEmpty()) {
            return EMPTY_MODEL;
        }
        ClientLevel clientWorld = world instanceof ClientLevel ? (ClientLevel)world : null;
        return MODEL_CACHE.get(new BakedModelKey(clientWorld, itemStack, displayContext));
    }

    public static Model bakeModel(ClientLevel world, ItemStack itemStack, ItemDisplayContext displayContext) {
        ItemChunkLayerSortedListBuilder builder = ItemChunkLayerSortedListBuilder.getThreadLocal();
        BakedItemModelBufferer.bufferItemStack(itemStack, (BlockAndTintGetter)world, displayContext, (renderType, shaded, data) -> {
            Material material = ModelUtil.getItemMaterial(renderType);
            if (material == null) {
                material = Materials.TRANSLUCENT_ENTITY;
            }
            if (itemStack.getItem() instanceof BlockItem && material.transparency() == Transparency.TRANSLUCENT) {
                material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
            }
            SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=ItemModels,ItemStack=" + String.valueOf(itemStack) + ",renderType=" + String.valueOf(renderType));
            builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
        }, (renderType, material, mesh) -> {
            if (itemStack.getItem() instanceof BlockItem && material.transparency() == Transparency.TRANSLUCENT) {
                material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
            }
            builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder.build());
    }

    public record BakedModelKey(ClientLevel world, ItemStack stack, ItemDisplayContext displayContext) {
        @Override
        public int hashCode() {
            return Objects.hash(this.world, ItemStack.hashItemAndComponents((ItemStack)this.stack), this.displayContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            ClientLevel otherWorld;
            ClientLevel clientLevel;
            if (!(obj instanceof BakedModelKey)) return false;
            BakedModelKey bakedModelKey = (BakedModelKey)obj;
            try {
                otherWorld = clientLevel = bakedModelKey.world();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ClientLevel otherStack = clientLevel = bakedModelKey.stack();
            ClientLevel otherDisplayContext = clientLevel = bakedModelKey.displayContext();
            boolean stackEqual = this.stack == otherStack || ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)otherStack);
            if (this.world != otherWorld) return false;
            if (!stackEqual) return false;
            if (this.displayContext != otherDisplayContext) return false;
            return true;
        }
    }
}

