/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChestVisual<T extends BlockEntity>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(Sheets.CHEST_SHEET).mipmap(false).build();
    private static final Map<ChestType, ModelLayerLocation> LAYER_LOCATIONS = new EnumMap<ChestType, ModelLayerLocation>(ChestType.class);
    @Nullable
    private final InstanceTree instances;
    @Nullable
    private final InstanceTree lid;
    @Nullable
    private final InstanceTree lock;
    @Nullable
    private final Matrix4fc initialPose;
    private final BrightnessCombiner brightnessCombiner = new BrightnessCombiner();
    @Nullable
    private final DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> neighborCombineResult;
    @Nullable
    private final Float2FloatFunction lidProgress;
    private float lastProgress = Float.NaN;

    public ChestVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        Block block = this.blockState.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock chestBlock = (AbstractChestBlock)block;
            ChestType chestType = this.blockState.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)this.blockState.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
            ChestRenderer renderer = (ChestRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
            net.minecraft.client.resources.model.Material texture = Sheets.chooseMaterial((ChestRenderState.ChestMaterialType)renderer.getChestMaterial(blockEntity, ChestVisual.isChristmas()), (ChestType)chestType);
            this.instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(LAYER_LOCATIONS.get(chestType), texture, MATERIAL));
            this.lid = this.instances.childOrThrow("lid");
            this.lock = this.instances.childOrThrow("lock");
            this.initialPose = this.createInitialPose();
            this.neighborCombineResult = chestBlock.combine(this.blockState, this.level, this.pos, true);
            this.lidProgress = (Float2FloatFunction)this.neighborCombineResult.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)blockEntity)));
            this.lastProgress = this.lidProgress.get(partialTick);
            this.applyLidTransform(this.lastProgress);
        } else {
            this.instances = null;
            this.lid = null;
            this.lock = null;
            this.initialPose = null;
            this.neighborCombineResult = null;
            this.lidProgress = null;
        }
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private Matrix4f createInitialPose() {
        BlockPos visualPos = this.getVisualPosition();
        float horizontalAngle = ((Direction)this.blockState.getValue((Property)ChestBlock.FACING)).toYRot();
        return new Matrix4f().translate((float)visualPos.getX(), (float)visualPos.getY(), (float)visualPos.getZ()).translate(0.5f, 0.5f, 0.5f).rotateY(-horizontalAngle * ((float)Math.PI / 180)).translate(-0.5f, -0.5f, -0.5f);
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        if (this.neighborCombineResult != null) {
            this.lightSections.sections((LongSet)this.neighborCombineResult.apply((DoubleBlockCombiner.Combiner)new SectionPosCombiner()));
        } else {
            this.lightSections.sections(LongSet.of((long)SectionPos.asLong((BlockPos)this.pos)));
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.instances == null) {
            return;
        }
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        float progress = this.lidProgress.get(context.partialTick());
        if (this.lastProgress == progress) {
            return;
        }
        this.lastProgress = progress;
        this.applyLidTransform(progress);
    }

    private void applyLidTransform(float progress) {
        progress = 1.0f - progress;
        progress = 1.0f - progress * progress * progress;
        this.lid.xRot(-(progress * 1.5707964f));
        this.lock.xRot(this.lid.xRot());
        this.instances.updateInstancesStatic(this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        if (this.instances != null) {
            int packedLight = (Integer)this.neighborCombineResult.apply((DoubleBlockCombiner.Combiner)this.brightnessCombiner);
            this.instances.traverse(instance -> instance.light(packedLight).setChanged());
        }
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.instances != null) {
            this.instances.traverse(consumer);
        }
    }

    @Override
    protected void _delete() {
        if (this.instances != null) {
            this.instances.delete();
        }
    }

    static {
        LAYER_LOCATIONS.put(ChestType.SINGLE, ModelLayers.CHEST);
        LAYER_LOCATIONS.put(ChestType.LEFT, ModelLayers.DOUBLE_CHEST_LEFT);
        LAYER_LOCATIONS.put(ChestType.RIGHT, ModelLayers.DOUBLE_CHEST_RIGHT);
    }

    private class BrightnessCombiner
    implements DoubleBlockCombiner.Combiner<BlockEntity, Integer> {
        private BrightnessCombiner() {
        }

        public Integer acceptDouble(BlockEntity first, BlockEntity second) {
            int firstLight = LevelRenderer.getLightColor((BlockAndTintGetter)first.getLevel(), (BlockPos)first.getBlockPos());
            int secondLight = LevelRenderer.getLightColor((BlockAndTintGetter)second.getLevel(), (BlockPos)second.getBlockPos());
            int firstBlockLight = LightTexture.block((int)firstLight);
            int secondBlockLight = LightTexture.block((int)secondLight);
            int firstSkyLight = LightTexture.sky((int)firstLight);
            int secondSkyLight = LightTexture.sky((int)secondLight);
            return LightTexture.pack((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
        }

        public Integer acceptSingle(BlockEntity single) {
            return LevelRenderer.getLightColor((BlockAndTintGetter)single.getLevel(), (BlockPos)single.getBlockPos());
        }

        public Integer acceptNone() {
            return LevelRenderer.getLightColor((BlockAndTintGetter)ChestVisual.this.level, (BlockPos)ChestVisual.this.pos);
        }
    }

    private class SectionPosCombiner
    implements DoubleBlockCombiner.Combiner<BlockEntity, LongSet> {
        private SectionPosCombiner() {
        }

        public LongSet acceptDouble(BlockEntity first, BlockEntity second) {
            long secondSection;
            long firstSection = SectionPos.asLong((BlockPos)first.getBlockPos());
            if (firstSection == (secondSection = SectionPos.asLong((BlockPos)second.getBlockPos()))) {
                return LongSet.of((long)firstSection);
            }
            return LongSet.of((long)firstSection, (long)secondSection);
        }

        public LongSet acceptSingle(BlockEntity single) {
            return LongSet.of((long)SectionPos.asLong((BlockPos)single.getBlockPos()));
        }

        public LongSet acceptNone() {
            return LongSet.of((long)SectionPos.asLong((BlockPos)ChestVisual.this.pos));
        }
    }
}

