/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class ItemVisual
extends AbstractEntityVisual<ItemEntity>
implements SimpleDynamicVisual {
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(RandomSource::createNewThreadLocalInstance);
    private final PoseStack pPoseStack = new PoseStack();
    private final ItemStackRenderState itemRenderState = new ItemStackRenderState();
    private ItemModel itemModel;
    private Model currentModel;
    private ItemStack currentStack;
    private final InstanceRecycler<TransformedInstance> instances;

    public ItemVisual(VisualizationContext ctx, ItemEntity entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.updateModel(entity.getItem());
        this.instances = new InstanceRecycler<TransformedInstance>(this::getInstance);
        this.animate(partialTick);
    }

    public static boolean isSupported(ItemEntity entity) {
        if (entity.getClass() != ItemEntity.class) {
            return false;
        }
        return ItemModels.isSupported(entity.getItem(), ItemDisplayContext.GROUND);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum())) {
            return;
        }
        ItemStack stack = ((ItemEntity)this.entity).getItem();
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.currentStack, (ItemStack)stack)) {
            this.updateModel(stack);
            this.instances.delete();
        }
        this.animate(ctx.partialTick());
    }

    private void updateModel(ItemStack stack) {
        this.currentStack = stack.copy();
        this.itemModel = ItemModels.getModel(this.currentStack);
        this.currentModel = ItemModels.get(this.level, this.currentStack, ItemDisplayContext.GROUND);
    }

    private TransformedInstance getInstance() {
        return this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, this.currentModel).createInstance();
    }

    private void animate(float partialTick) {
        ClientLevel clientWorld;
        this.pPoseStack.setIdentity();
        TransformStack.of(this.pPoseStack).translate((Vector3fc)this.getVisualPosition(partialTick));
        this.instances.resetCount();
        ItemStack itemstack = ((ItemEntity)this.entity).getItem();
        if (itemstack.isEmpty()) {
            return;
        }
        this.itemRenderState.clear();
        ItemModelResolver manager = Minecraft.getInstance().getItemModelResolver();
        Level level = ((ItemEntity)this.entity).level();
        ClientLevel world = level instanceof ClientLevel ? (clientWorld = (ClientLevel)level) : null;
        this.itemRenderState.displayContext = ItemDisplayContext.GROUND;
        this.itemModel.update(this.itemRenderState, itemstack, manager, ItemDisplayContext.GROUND, world, null, ((ItemEntity)this.entity).getId());
        if (this.itemRenderState.isEmpty()) {
            return;
        }
        float age = (float)((ItemEntity)this.entity).getAge() + partialTick;
        AABB box = this.itemRenderState.getModelBoundingBox();
        float f = -((float)box.minY) + 0.0625f;
        if (this.shouldBob()) {
            float g = Mth.sin((double)(age / 10.0f + ((ItemEntity)this.entity).bobOffs)) * 0.1f + 0.1f;
            this.pPoseStack.translate(0.0f, g + f, 0.0f);
        } else {
            this.pPoseStack.translate(0.0f, f, 0.0f);
        }
        float h = ItemEntity.getSpin((float)age, (float)((ItemEntity)this.entity).bobOffs);
        this.pPoseStack.mulPose((Quaternionfc)Axis.YP.rotation(h));
        int i = this.getRenderAmount(itemstack);
        int seed = itemstack.isEmpty() ? 187 : Item.getId((Item)itemstack.getItem()) + itemstack.getDamageValue();
        RandomSource random = RANDOM.get();
        random.setSeed((long)seed);
        int light = LightTexture.pack((int)this.level.getBrightness(LightLayer.BLOCK, ((ItemEntity)this.entity).blockPosition()), (int)this.level.getBrightness(LightLayer.SKY, ((ItemEntity)this.entity).blockPosition()));
        float lengthZ = (float)box.getZsize();
        if (lengthZ > 0.0625f) {
            this.instances.get().setTransform(this.pPoseStack.last()).light(light).setChanged();
            if (this.shouldSpreadItems()) {
                for (int j = 1; j < i; ++j) {
                    this.pPoseStack.pushPose();
                    float x = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float y = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float z = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    this.pPoseStack.translate(x, y, z);
                    this.instances.get().setTransform(this.pPoseStack.last()).light(light).setChanged();
                    this.pPoseStack.popPose();
                }
            }
        } else {
            float l = lengthZ * 1.5f;
            this.pPoseStack.translate(0.0f, 0.0f, -(l * (float)(i - 1) / 2.0f));
            this.instances.get().setTransform(this.pPoseStack.last()).light(light).setChanged();
            this.pPoseStack.translate(0.0f, 0.0f, l);
            if (this.shouldSpreadItems()) {
                for (int m = 1; m < i; ++m) {
                    this.pPoseStack.pushPose();
                    float x = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float y = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    this.pPoseStack.translate(x, y, 0.0f);
                    this.instances.get().setTransform(this.pPoseStack.last()).light(light).setChanged();
                    this.pPoseStack.popPose();
                    this.pPoseStack.translate(0.0f, 0.0f, l);
                }
            }
        }
        this.instances.discardExtra();
    }

    protected int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.getCount() > 48) {
            i = 5;
        } else if (pStack.getCount() > 32) {
            i = 4;
        } else if (pStack.getCount() > 16) {
            i = 3;
        } else if (pStack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

