/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.minecart.MinecartSim2020;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.entity.vehicle.minecart.MinecartFurnace;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OrientedContraptionEntity
extends AbstractContraptionEntity {
    private static final Ingredient FUEL_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL});
    private static final EntityDataAccessor<Optional<UUID>> COUPLING = SynchedEntityData.defineId(OrientedContraptionEntity.class, AllSynchedDatas.OPTIONAL_UUID_HANDLER);
    private static final EntityDataAccessor<Direction> INITIAL_ORIENTATION = SynchedEntityData.defineId(OrientedContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    protected Vec3 motionBeforeStall = Vec3.ZERO;
    protected boolean forceAngle;
    private boolean attachedExtraInventories = false;
    private boolean manuallyPlaced;
    public float prevYaw;
    public float yaw;
    public float targetYaw;
    public float prevPitch;
    public float pitch;
    public int nonDamageTicks = 10;

    public OrientedContraptionEntity(EntityType<? extends OrientedContraptionEntity> type, Level world) {
        super(type, world);
    }

    public static OrientedContraptionEntity create(Level world, Contraption contraption, Direction initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity((EntityType<? extends OrientedContraptionEntity>)AllEntityTypes.ORIENTED_CONTRAPTION, world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(Level world, Contraption contraption, Direction initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(Direction direction) {
        this.entityData.set(INITIAL_ORIENTATION, (Object)direction);
    }

    public Direction getInitialOrientation() {
        return (Direction)this.entityData.get(INITIAL_ORIENTATION);
    }

    @Override
    public float getYawOffset() {
        return this.getInitialYaw();
    }

    public float getInitialYaw() {
        return (this.isInitialOrientationPresent() ? (Direction)this.entityData.get(INITIAL_ORIENTATION) : Direction.SOUTH).toYRot();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COUPLING, Optional.empty());
        builder.define(INITIAL_ORIENTATION, (Object)Direction.UP);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        float yawOffset = this.getYawOffset();
        crs.zRotation = this.pitch;
        crs.yRotation = -this.yaw + yawOffset;
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            crs.secondYRotation = -this.yaw;
            crs.yRotation = yawOffset;
        }
        return crs;
    }

    public void stopRiding() {
        if (!this.level().isClientSide() && this.isAlive()) {
            this.disassemble();
        }
        super.stopRiding();
    }

    @Override
    protected void readAdditional(ValueInput view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        view.read("InitialOrientation", (Codec)Direction.CODEC).ifPresent(this::setInitialOrientation);
        this.yaw = view.getFloatOr("Yaw", 0.0f);
        this.pitch = view.getFloatOr("Pitch", 0.0f);
        this.manuallyPlaced = view.getBooleanOr("Placed", false);
        float forceYaw = view.getFloatOr("ForceYaw", -1.0f);
        if (forceYaw != -1.0f) {
            this.startAtYaw(forceYaw);
        }
        view.read("CachedMotion", Vec3.CODEC).ifPresent(motion -> {
            this.motionBeforeStall = motion;
            if (!this.motionBeforeStall.equals((Object)Vec3.ZERO)) {
                this.prevYaw = this.yaw += OrientedContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.setDeltaMovement(Vec3.ZERO);
        });
        this.setCouplingId(view.read("OnCoupling", UUIDUtil.CODEC).orElse(null));
    }

    @Override
    protected void writeAdditional(ValueOutput view, boolean spawnPacket) {
        Direction optional;
        super.writeAdditional(view, spawnPacket);
        if (this.motionBeforeStall != null) {
            view.store("CachedMotion", Vec3.CODEC, (Object)this.motionBeforeStall);
        }
        if ((optional = (Direction)this.entityData.get(INITIAL_ORIENTATION)).getAxis().isHorizontal()) {
            view.store("InitialOrientation", (Codec)Direction.CODEC, (Object)optional);
        }
        if (this.forceAngle) {
            view.putFloat("ForceYaw", this.yaw);
            this.forceAngle = false;
        }
        view.putBoolean("Placed", this.manuallyPlaced);
        view.putFloat("Yaw", this.yaw);
        view.putFloat("Pitch", this.pitch);
        if (this.getCouplingId() != null) {
            view.store("OnCoupling", UUIDUtil.CODEC, (Object)this.getCouplingId());
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (INITIAL_ORIENTATION.equals(key) && this.isInitialOrientationPresent() && !this.manuallyPlaced) {
            this.startAtInitialYaw();
        }
    }

    public boolean isInitialOrientationPresent() {
        return ((Direction)this.entityData.get(INITIAL_ORIENTATION)).getAxis().isHorizontal();
    }

    public void startAtInitialYaw() {
        this.startAtYaw(this.getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        this.yaw = this.prevYaw = yaw;
        this.targetYaw = this.prevYaw;
        this.forceAngle = true;
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getInitialYaw(), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, this.getViewXRot(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, this.getViewYRot(partialTicks), Direction.Axis.Y);
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getViewYRot(partialTicks), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, -this.getViewXRot(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, -this.getInitialYaw(), Direction.Axis.Y);
        return localPos;
    }

    public float getViewYRot(float partialTicks) {
        return -(partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp(partialTicks, this.prevYaw, this.yaw));
    }

    public float getViewXRot(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp(partialTicks, this.prevPitch, this.pitch);
    }

    @Override
    protected void tickContraption() {
        Optional<MinecartController> data;
        boolean rotating;
        Entity e;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if ((e = this.getVehicle()) == null) {
            return;
        }
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = this.isStalled();
        Contraption contraption = this.contraption;
        if (contraption instanceof MountedContraption) {
            MountedContraption mountedContraption = (MountedContraption)contraption;
            rotationLock = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATE_PAUSED;
        }
        Entity riding = e;
        while (riding.getVehicle() != null && !(this.contraption instanceof StabilizedContraption)) {
            riding = riding.getVehicle();
        }
        boolean isOnCoupling = false;
        UUID couplingId = this.getCouplingId();
        boolean bl = isOnCoupling = couplingId != null && riding instanceof AbstractMinecart;
        if (!this.attachedExtraInventories) {
            this.attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            this.attachedExtraInventories = true;
        }
        if (!(rotating = this.updateOrientation(rotationLock, wasStalled, riding, isOnCoupling)) || !pauseWhileRotating) {
            this.tickActors();
        }
        boolean isStalled = this.isStalled();
        boolean isClient = this.level().isClientSide();
        boolean isUpdate = true;
        if (riding instanceof AbstractMinecart && (data = AllSynchedDatas.MINECART_CONTROLLER.get(riding)).isPresent()) {
            if (!isClient) {
                data.get().setStalledExternally(isStalled);
            }
            isUpdate = false;
        }
        if (isUpdate) {
            if (isStalled) {
                if (!wasStalled) {
                    this.motionBeforeStall = riding.getDeltaMovement();
                }
                riding.setDeltaMovement(0.0, 0.0, 0.0);
            }
            if (wasStalled && !isStalled) {
                riding.setDeltaMovement(this.motionBeforeStall);
                this.motionBeforeStall = Vec3.ZERO;
            }
        }
        if (isClient) {
            return;
        }
        if (!this.isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
                if (coupledCarts == null) {
                    return;
                }
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            this.powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    private BlockPos getCurrentRailPosition(AbstractMinecart entity) {
        int x = Mth.floor((double)entity.getX());
        int y = Mth.floor((double)entity.getY());
        int z = Mth.floor((double)entity.getZ());
        BlockPos pos = new BlockPos(x, y, z);
        if (entity.level().getBlockState(pos.below()).is(BlockTags.RAILS)) {
            pos = pos.below();
        }
        return pos;
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, Entity riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return false;
            }
            Vec3 positionVec = ((MinecartController)coupledCarts.getFirst()).cart().position();
            Vec3 coupledVec = ((MinecartController)coupledCarts.getSecond()).cart().position();
            double diffX = positionVec.x - coupledVec.x;
            double diffY = positionVec.y - coupledVec.y;
            double diffZ = positionVec.z - coupledVec.z;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.yaw = (float)(Mth.atan2((double)diffZ, (double)diffX) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI);
            if (this.getCouplingId().equals(riding.getUUID())) {
                this.pitch *= -1.0f;
                this.yaw += 180.0f;
            }
            return false;
        }
        Contraption positionVec = this.contraption;
        if (positionVec instanceof StabilizedContraption) {
            StabilizedContraption stabilized = (StabilizedContraption)positionVec;
            if (!(riding instanceof OrientedContraptionEntity)) {
                return false;
            }
            OrientedContraptionEntity parent = (OrientedContraptionEntity)riding;
            Direction facing = stabilized.getFacing();
            if (facing.getAxis().isVertical()) {
                return false;
            }
            this.prevYaw = this.yaw;
            this.yaw = AngleHelper.wrapAngle180(this.getInitialYaw() - parent.getInitialYaw()) - parent.getViewYRot(1.0f);
            return false;
        }
        this.prevYaw = this.yaw;
        if (wasStalled) {
            return false;
        }
        boolean rotating = false;
        Vec3 movementVector = riding.getDeltaMovement();
        Vec3 locationDiff = riding.position().subtract(riding.xo, riding.yo, riding.zo);
        if (!(riding instanceof AbstractMinecart)) {
            movementVector = locationDiff;
        }
        Vec3 motion = movementVector.normalize();
        if (!rotationLock) {
            if (riding instanceof AbstractMinecart) {
                AbstractMinecart minecartEntity = (AbstractMinecart)riding;
                BlockPos railPosition = this.getCurrentRailPosition(minecartEntity);
                BlockState blockState = this.level().getBlockState(railPosition);
                Block block = blockState.getBlock();
                if (block instanceof BaseRailBlock) {
                    BaseRailBlock abstractRailBlock = (BaseRailBlock)block;
                    RailShape railDirection = (RailShape)blockState.getValue(abstractRailBlock.getShapeProperty());
                    motion = VecHelper.project(motion, MinecartSim2020.getRailVec(railDirection));
                }
            }
            if (motion.length() > 0.0) {
                this.targetYaw = OrientedContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            float maxApproachSpeed = (float)(motion.length() * 12.0 / Math.max(1.0, this.getBoundingBox().getXsize() / 6.0));
            float yawHint = AngleHelper.getShortestAngleDiff(this.yaw, OrientedContraptionEntity.yawFromVector(locationDiff));
            float approach = AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw, yawHint);
            approach = Mth.clamp((float)approach, (float)(-maxApproachSpeed), (float)maxApproachSpeed);
            this.yaw += approach;
            if (Math.abs(AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(Entity riding) {
        ItemStack coal;
        MountedItemStorageWrapper fuelItems;
        int fuel;
        if (!(riding instanceof MinecartFurnace)) {
            return;
        }
        MinecartFurnace furnaceCart = (MinecartFurnace)riding;
        int fuelBefore = fuel = furnaceCart.fuel;
        double pushX = furnaceCart.push.x;
        double pushZ = furnaceCart.push.z;
        int i = Mth.floor((double)furnaceCart.getX());
        int j = Mth.floor((double)furnaceCart.getY());
        int k = Mth.floor((double)furnaceCart.getZ());
        if (furnaceCart.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        if (this.level().getBlockState(blockpos).is(BlockTags.RAILS) && fuel > 1) {
            riding.setDeltaMovement(riding.getDeltaMovement().normalize().scale(1.0));
        }
        if (fuel < 5 && this.contraption != null && (fuelItems = this.contraption.getStorage().getFuelItems()) != null && !(coal = fuelItems.extract((Predicate)FUEL_ITEMS, 1)).isEmpty()) {
            fuel += 3600;
        }
        if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
            furnaceCart.push = new Vec3(pushX, 0.0, pushZ);
            furnaceCart.fuel = fuel;
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = this.getCouplingId();
        if (couplingId == null) {
            return null;
        }
        MinecartController controller = CapabilityMinecartController.getIfPresent(this.level(), couplingId);
        if (controller == null || !controller.isPresent()) {
            return null;
        }
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(this.level(), coupledCart);
        if (coupledController == null || !coupledController.isPresent()) {
            return null;
        }
        return Couple.create(controller, coupledController);
    }

    protected void attachInventoriesFromRidingCarts(Entity riding, boolean isOnCoupling, UUID couplingId) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof MountedContraption)) {
            return;
        }
        MountedContraption mc = (MountedContraption)contraption;
        if (!isOnCoupling) {
            mc.addExtraInventories(riding);
            return;
        }
        Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        coupledCarts.map(MinecartController::cart).forEach(mc::addExtraInventories);
    }

    @Nullable
    public UUID getCouplingId() {
        return ((Optional)this.entityData.get(COUPLING)).orElse(null);
    }

    public void setCouplingId(UUID id) {
        this.entityData.set(COUPLING, Optional.ofNullable(id));
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return entity instanceof AbstractContraptionEntity ? Vec3.ZERO : new Vec3(0.0, 0.19, 0.0);
    }

    @Override
    public Vec3 getAnchorVec() {
        Vec3 anchorVec = super.getAnchorVec();
        return anchorVec.subtract(0.5, 0.0, 0.5);
    }

    @Override
    public Vec3 getPrevAnchorVec() {
        Vec3 prevAnchorVec = super.getPrevAnchorVec();
        return prevAnchorVec.subtract(0.5, 0.0, 0.5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = BlockPos.containing((Position)this.getAnchorVec().add(0.5, 0.5, 0.5));
        return new StructureTransform(offset, 0.0f, -this.yaw + this.getInitialYaw(), 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return this.yaw;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.yaw = angle;
    }
}

