/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ContraptionControlsBlockEntity
extends SmartBlockEntity {
    public ServerFilteringBehaviour filtering;
    public boolean disabled;
    public boolean powered;
    public LerpedFloat indicator = LerpedFloat.angular().startWithValue(0.0);
    public LerpedFloat button = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.125, LerpedFloat.Chaser.EXP);

    public ContraptionControlsBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.CONTRAPTION_CONTROLS, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this);
        behaviours.add(this.filtering);
        this.filtering.withPredicate(stack -> stack.is(AllItemTags.CONTRAPTION_CONTROLLED));
    }

    public void pressButton() {
        this.button.setValue(1.0);
    }

    public void updatePoweredState() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean powered = this.level.hasNeighborSignal(this.worldPosition);
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        this.disabled = powered;
        this.notifyUpdate();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updatePoweredState();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            return;
        }
        this.tickAnimations();
        int value = this.disabled ? 180 : 0;
        this.indicator.setValue(value);
        this.indicator.updateChaseTarget(value);
    }

    public void tickAnimations() {
        this.button.tickChaser();
        this.indicator.tickChaser();
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.disabled = view.getBooleanOr("Disabled", false);
        this.powered = view.getBooleanOr("Powered", false);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putBoolean("Disabled", this.disabled);
        view.putBoolean("Powered", this.powered);
    }

    public static void sendStatus(Player player, ItemStack filter, boolean enabled) {
        MutableComponent state = Component.translatable((String)("create.contraption.controls.actor_toggle." + (enabled ? "on" : "off"))).withColor(enabled ? 10739541 : 15635014);
        if (filter.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"create.contraption.controls.all_actor_toggle", (Object[])new Object[]{state}), true);
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)"create.contraption.controls.specific_actor_toggle", (Object[])new Object[]{filter.getHoverName().getString(), state}), true);
    }
}

