/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.psi;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import com.zurrtum.create.infrastructure.items.SidedItemInventory;
import com.zurrtum.create.infrastructure.transfer.SlotRangeCache;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortableItemInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity {
    public final Container capability = new InterfaceItemHandler();

    public PortableItemInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.PORTABLE_STORAGE_INTERFACE, pos, state);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        ((InterfaceItemHandler)this.capability).setInventory(contraption.getStorage().getAllItems());
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void stopTransferring() {
        ((InterfaceItemHandler)this.capability).setEmpty();
        super.stopTransferring();
    }

    class InterfaceItemHandler
    implements SidedItemInventory {
        private static final Container EMPTY = new ItemStackHandler(0);
        private int[] slots = SlotRangeCache.EMPTY;
        private Container wrapped = EMPTY;
        private boolean mark = false;

        InterfaceItemHandler() {
        }

        public int[] getSlotsForFace(Direction side) {
            return this.slots;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
            if (this.wrapped == EMPTY) {
                return false;
            }
            return ((WorldlyContainer)this.wrapped).canTakeItemThroughFace(slot, stack, dir);
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
            if (this.wrapped == EMPTY) {
                return false;
            }
            return ((WorldlyContainer)this.wrapped).canPlaceItemThroughFace(slot, stack, dir);
        }

        public void setInventory(CombinedInvWrapper wrapped) {
            this.wrapped = wrapped;
            this.slots = wrapped.getSlotsForFace(null);
        }

        public void setEmpty() {
            this.wrapped = EMPTY;
            this.slots = SlotRangeCache.EMPTY;
        }

        public int getContainerSize() {
            return this.slots.length;
        }

        public int getMaxStackSize() {
            return this.wrapped.getMaxStackSize();
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.wrapped.getMaxStackSize(stack);
        }

        public ItemStack getItem(int slot) {
            this.mark = true;
            return this.wrapped.getItem(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            this.mark = true;
            this.wrapped.setItem(slot, stack);
        }

        public int insert(ItemStack stack, int maxAmount, Direction side) {
            int insert = this.wrapped.insert(stack, maxAmount, side);
            if (insert != 0) {
                this.setChanged();
            }
            return insert;
        }

        public int extract(ItemStack stack, int maxAmount, Direction side) {
            int extract = this.wrapped.extract(stack, maxAmount, side);
            if (extract != 0) {
                this.setChanged();
            }
            return extract;
        }

        @Override
        public void setChanged() {
            PortableItemInterfaceBlockEntity.this.onContentTransferred();
            if (this.mark) {
                this.mark = false;
                this.wrapped.setChanged();
            }
        }

        @NotNull
        public Iterator<ItemStack> iterator(Direction side) {
            return this.wrapped.iterator(side);
        }
    }
}

